/*
 * Decompiled with CFR 0.152.
 */
package com.jeta.forms.components.image;

import com.jeta.forms.gui.effects.ImagePainter;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.Icon;
import javax.swing.JComponent;

public class ImageComponent
extends JComponent {
    private int m_halign = 0;
    private int m_valign = 3;
    private Icon m_icon;
    private Dimension m_pref_size = new Dimension(16, 16);
    private ImagePainter m_painter;
    private Rectangle m_painter_rect;

    public int getHorizontalAlignment() {
        return this.m_halign;
    }

    public Dimension getPreferredSize() {
        Insets insets = this.getInsets();
        this.m_pref_size.setSize(insets.left + insets.right + this.getIconWidth(), insets.top + insets.bottom + this.getIconHeight());
        return this.m_pref_size;
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public int getVerticalAlignment() {
        return this.m_valign;
    }

    public Icon getIcon() {
        return this.m_icon;
    }

    public int getIconHeight() {
        if (this.m_icon == null) {
            return 16;
        }
        return this.m_icon.getIconHeight();
    }

    public int getIconWidth() {
        if (this.m_icon == null) {
            return 16;
        }
        return this.m_icon.getIconWidth();
    }

    public void setHorizontalAlignment(int n) {
        this.m_halign = n;
        this.m_painter = null;
    }

    public void setIcon(Icon icon) {
        this.m_icon = icon;
        if (icon != null) {
            this.m_pref_size.setSize(Math.max(16, icon.getIconWidth()), Math.max(16, icon.getIconHeight()));
        }
        this.m_painter = null;
        this.revalidate();
    }

    public void setVerticalAlignment(int n) {
        this.m_valign = n;
        this.m_painter = null;
    }

    public void paintComponent(Graphics graphics) {
        Color color;
        super.paintComponent(graphics);
        Insets insets = this.getInsets();
        int n = insets.left;
        int n2 = insets.top;
        int n3 = this.getWidth() - insets.left - insets.right;
        int n4 = this.getHeight() - insets.top - insets.bottom;
        if (this.m_painter == null) {
            this.m_painter = new ImagePainter(this.m_icon, this.getHorizontalAlignment(), this.getVerticalAlignment());
        }
        if (this.m_painter_rect == null) {
            this.m_painter_rect = new Rectangle();
        }
        this.m_painter_rect.setBounds(n, n2, n3, n4);
        if (this.isOpaque() && (color = this.getBackground()) != null) {
            Rectangle rectangle = graphics.getClipBounds();
            if (this.m_painter_rect.intersects(rectangle)) {
                Rectangle rectangle2 = this.m_painter_rect.intersection(rectangle);
                graphics.setClip(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                Color color2 = graphics.getColor();
                graphics.setColor(color);
                graphics.fillRect(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                graphics.setColor(color2);
            }
            graphics.setClip(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        this.m_painter.paint(this, graphics, this.m_painter_rect);
    }
}

