/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.dom;

import io.sf.carte.doc.DOMNotSupportedException;
import io.sf.carte.doc.dom.AbstractDOMNode;
import io.sf.carte.doc.dom.DOMNode;
import io.sf.carte.doc.dom.NodeFilter;
import io.sf.carte.doc.dom.TreeWalker;
import org.w3c.dom.Node;

class TreeWalkerImpl
implements TreeWalker {
    private final AbstractDOMNode rootNode;
    private AbstractDOMNode currentNode;
    private boolean begin = true;
    private final int whatToShow;
    private final NodeFilter nodeFilter;

    TreeWalkerImpl(AbstractDOMNode rootNode, int whatToShow, NodeFilter filter) {
        this.rootNode = rootNode;
        this.nodeFilter = filter;
        this.whatToShow = whatToShow;
        this.currentNode = rootNode;
    }

    @Override
    public AbstractDOMNode getRoot() {
        return this.rootNode;
    }

    @Override
    public int getWhatToShow() {
        return this.whatToShow;
    }

    @Override
    public NodeFilter getNodeFilter() {
        return this.nodeFilter;
    }

    @Override
    public DOMNode getCurrentNode() {
        return this.currentNode;
    }

    @Override
    public void setCurrentNode(Node currentNode) {
        if (currentNode == null) {
            throw new DOMNotSupportedException("current node cannot be null");
        }
        Node node = currentNode;
        while (currentNode != null) {
            if (node == this.rootNode) {
                this.currentNode = (AbstractDOMNode)currentNode;
                if (currentNode == node) {
                    this.begin = true;
                }
                return;
            }
            node = node.getParentNode();
        }
        throw new DOMNotSupportedException("This implementation does not support setting the current node outside of the root-based tree");
    }

    private boolean isToShow(Node node) {
        int maskBit = NodeFilter.maskTable[node.getNodeType() - 1];
        return (this.whatToShow & maskBit) == maskBit;
    }

    private short filter(Node node) {
        if (!this.isToShow(node)) {
            return 3;
        }
        return this.nodeFilter == null ? (short)1 : this.nodeFilter.acceptNode(node);
    }

    @Override
    public DOMNode nextNode() {
        AbstractDOMNode next;
        if (this.currentNode == this.rootNode) {
            if (!this.begin) {
                return null;
            }
            next = this.findNext(this.currentNode);
            if (next != this.rootNode) {
                this.currentNode = next;
                this.begin = false;
            } else {
                next = null;
            }
        } else {
            next = this.findNext();
            if (next != this.rootNode) {
                this.currentNode = next;
            } else {
                next = null;
            }
        }
        return next;
    }

    private AbstractDOMNode findNext() {
        AbstractDOMNode current = this.nextVisible(this.currentNode);
        return this.findNext(current);
    }

    private AbstractDOMNode findNext(AbstractDOMNode current) {
        short filter;
        AbstractDOMNode next = this.nextNode(current);
        while (next != this.rootNode && (filter = this.filter(next)) != 1) {
            if (filter != 3) {
                next = this.nextSiblingOrParent(next);
                continue;
            }
            next = this.nextNode(next);
        }
        return next;
    }

    private AbstractDOMNode highestInvisibleAncestorOrMe(AbstractDOMNode current) {
        AbstractDOMNode node = current;
        while (node != this.rootNode) {
            if (this.filter(node) == 2) {
                current = node;
            }
            if ((node = (AbstractDOMNode)node.getParentNode()) != null) continue;
            break;
        }
        return current;
    }

    private AbstractDOMNode nextVisible(AbstractDOMNode current) {
        AbstractDOMNode ancestor = null;
        AbstractDOMNode node = current;
        while (node != this.rootNode) {
            if (this.filter(node) == 2) {
                ancestor = node;
            }
            if ((node = (AbstractDOMNode)node.getParentNode()) != null) continue;
        }
        if (ancestor != null) {
            if (ancestor != this.rootNode) {
                current = this.nextSiblingOrParent(ancestor);
                while (current != this.rootNode) {
                    short filter = this.filter(current);
                    if (filter == 2) {
                        current = this.nextSiblingOrParent(current);
                        continue;
                    }
                    if (filter == 3) {
                        current = this.nextNode(current);
                        continue;
                    }
                    break;
                }
            } else {
                current = this.rootNode;
            }
        }
        return current;
    }

    private AbstractDOMNode nextNode(AbstractDOMNode current) {
        AbstractDOMNode next = current.getNodeList().getFirst();
        if (next == null) {
            next = current != this.rootNode || this.rootNode.getNodeType() == 2 ? this.nextSiblingOrParent(current) : current;
        }
        return next;
    }

    private AbstractDOMNode nextSiblingOrParent(AbstractDOMNode current) {
        AbstractDOMNode next = current.nextSibling;
        if (next == null) {
            AbstractDOMNode parent = current.parentNode();
            if (parent != this.rootNode && parent != null) {
                return this.nextSiblingOrParent(parent);
            }
            next = this.rootNode;
        }
        return next;
    }

    private boolean isAccepted(AbstractDOMNode node) {
        return this.filter(node) == 1;
    }

    @Override
    public DOMNode previousNode() {
        AbstractDOMNode prev = this.findPrevious();
        if (prev != null) {
            if (prev != this.rootNode) {
                this.currentNode = prev;
            } else if (this.isAccepted(prev)) {
                this.currentNode = prev;
                this.begin = true;
            } else {
                prev = null;
            }
        }
        return prev;
    }

    private AbstractDOMNode findPrevious() {
        AbstractDOMNode current = this.highestInvisibleAncestorOrMe(this.currentNode);
        return this.findPrevious(current);
    }

    private AbstractDOMNode findPrevious(AbstractDOMNode current) {
        short filter;
        if (current == this.rootNode) {
            AbstractDOMNode node = null;
            if (!this.begin && (node = current.getNodeList().getLast()) != null && !this.isAccepted(node)) {
                node = this.findPrevious(node);
            }
            return node;
        }
        AbstractDOMNode previous = this.previousNode(current);
        while (previous != this.rootNode && previous != null && (filter = this.filter(previous)) != 1) {
            previous = this.previousNode(previous);
        }
        return previous;
    }

    private AbstractDOMNode previousNode(AbstractDOMNode current) {
        AbstractDOMNode previous = current.previousSibling;
        if (previous == null) {
            previous = current.parentNode();
        } else {
            while (true) {
                AbstractDOMNode prev;
                short filter;
                if ((filter = this.filter(previous)) != 2) {
                    prev = previous.getNodeList().getLast();
                    if (prev == null) break;
                    previous = prev;
                    continue;
                }
                prev = previous.previousSibling;
                if (prev == null) break;
                previous = prev;
            }
        }
        return previous;
    }

    @Override
    public DOMNode firstChild() {
        AbstractDOMNode node = this.findFirstChild();
        if (node != null) {
            this.currentNode = node;
        }
        return node;
    }

    private AbstractDOMNode findFirstChild() {
        AbstractDOMNode node;
        AbstractDOMNode current = this.highestInvisibleAncestorOrMe(this.currentNode);
        if (current == this.currentNode) {
            node = current.getNodeList().getFirst();
            while (node != null && !this.isAccepted(node)) {
                node = node.nextSibling;
            }
        } else {
            node = null;
        }
        return node;
    }

    @Override
    public DOMNode lastChild() {
        AbstractDOMNode node = this.findLastChild();
        if (node != null) {
            this.currentNode = node;
        }
        return node;
    }

    private AbstractDOMNode findLastChild() {
        AbstractDOMNode node;
        AbstractDOMNode current = this.highestInvisibleAncestorOrMe(this.currentNode);
        if (current == this.currentNode) {
            node = current.getNodeList().getLast();
            while (node != null && !this.isAccepted(node)) {
                node = node.previousSibling;
            }
        } else {
            node = null;
        }
        return node;
    }

    @Override
    public DOMNode nextSibling() {
        AbstractDOMNode node;
        if (this.currentNode != this.rootNode) {
            node = this.findNextSibling();
            if (node != null) {
                this.currentNode = node;
            }
        } else {
            node = null;
        }
        return node;
    }

    private AbstractDOMNode findNextSibling() {
        AbstractDOMNode node;
        AbstractDOMNode current = this.highestInvisibleAncestorOrMe(this.currentNode);
        if (current == this.currentNode) {
            node = current.nextSibling;
            while (node != null && !this.isAccepted(node)) {
                node = node.nextSibling;
            }
        } else {
            node = null;
        }
        return node;
    }

    @Override
    public DOMNode previousSibling() {
        AbstractDOMNode node;
        if (this.currentNode != this.rootNode) {
            node = this.findPreviousSibling();
            if (node != null) {
                this.currentNode = node;
            }
        } else {
            node = null;
        }
        return node;
    }

    private AbstractDOMNode findPreviousSibling() {
        AbstractDOMNode node;
        AbstractDOMNode current = this.highestInvisibleAncestorOrMe(this.currentNode);
        if (current == this.currentNode) {
            node = current.previousSibling;
            while (node != null && !this.isAccepted(node)) {
                node = node.previousSibling;
            }
        } else {
            node = null;
        }
        return node;
    }

    @Override
    public DOMNode parentNode() {
        AbstractDOMNode node = this.findParentNode();
        if (node != null) {
            if (node != this.rootNode) {
                this.currentNode = node;
            } else if (this.isAccepted(node)) {
                this.currentNode = node;
                this.begin = true;
            } else {
                node = null;
            }
        }
        return node;
    }

    private AbstractDOMNode findParentNode() {
        AbstractDOMNode anc;
        AbstractDOMNode node = this.currentNode != this.rootNode ? ((anc = this.highestInvisibleAncestorOrMe(this.currentNode)) == this.currentNode || anc != this.rootNode ? (AbstractDOMNode)anc.getParentNode() : null) : null;
        return node;
    }

    @Override
    public org.w3c.dom.traversal.NodeFilter getFilter() {
        if (this.nodeFilter instanceof org.w3c.dom.traversal.NodeFilter) {
            return (org.w3c.dom.traversal.NodeFilter)((Object)this.nodeFilter);
        }
        return null;
    }

    @Override
    public boolean getExpandEntityReferences() {
        return false;
    }
}

