/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.navigator.filters;

import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.internal.navigator.CommonNavigatorMessages;
import org.eclipse.ui.internal.navigator.filters.CommonFilterLabelProvider;
import org.eclipse.ui.internal.navigator.filters.ContentDescriptorContentProvider;
import org.eclipse.ui.internal.navigator.filters.CustomizationTab;
import org.eclipse.ui.navigator.INavigatorContentDescriptor;
import org.eclipse.ui.navigator.INavigatorContentService;

public class ContentExtensionsTab
extends CustomizationTab {
    protected ContentExtensionsTab(Composite parent, INavigatorContentService aContentService) {
        super(parent, aContentService);
        this.createControl();
    }

    private void createControl() {
        this.createInstructionsLabel(CommonNavigatorMessages.CommonFilterSelectionDialog_Select_the_available_extensions);
        this.createTable();
        this.getTableViewer().setContentProvider((IContentProvider)new ContentDescriptorContentProvider());
        this.getTableViewer().setLabelProvider((IBaseLabelProvider)new CommonFilterLabelProvider());
        this.getTableViewer().setInput((Object)this.getContentService());
        this.updateCheckedState();
    }

    private void updateCheckedState() {
        INavigatorContentDescriptor[] visibleExtensions;
        INavigatorContentDescriptor[] iNavigatorContentDescriptorArray = visibleExtensions = this.getContentService().getVisibleExtensions();
        int n = visibleExtensions.length;
        int n2 = 0;
        while (n2 < n) {
            INavigatorContentDescriptor visibleExtension = iNavigatorContentDescriptorArray[n2];
            if (this.getContentService().isActive(visibleExtension.getId())) {
                this.getTableViewer().setChecked((Object)visibleExtension, true);
            }
            ++n2;
        }
    }
}

