/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.terminal.backend;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.EventDispatcher;
import com.jediterm.terminal.Terminal;
import java.util.EventListener;
import java.util.HexFormat;
import java.util.List;
import java.util.Locale;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.block.reworked.TerminalShellIntegrationEventsListener;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0007\b\u0000\u0018\u0000 \u00162\u00020\u0001:\u0002\u0015\u0016B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\f0\u0010H\u0002J\u0016\u0010\u0011\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\f0\u0010H\u0002J\u000e\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\bJ\u000e\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\bR!\u0010\u0006\u001a\u0015\u0012\f\u0012\n \t*\u0004\u0018\u00010\b0\b0\u0007\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/terminal/backend/TerminalShellIntegrationController;", "", "terminalController", "Lcom/jediterm/terminal/Terminal;", "<init>", "(Lcom/jediterm/terminal/Terminal;)V", "dispatcher", "Lcom/intellij/util/EventDispatcher;", "Lorg/jetbrains/plugins/terminal/block/reworked/TerminalShellIntegrationEventsListener;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "currentCommand", "", "processCommandStartedEvent", "", "args", "", "processCommandFinishedEvent", "addListener", "listener", "removeListener", "Param", "Companion", "intellij.terminal.backend"})
public final class TerminalShellIntegrationController {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final EventDispatcher<TerminalShellIntegrationEventsListener> dispatcher;
    @Nullable
    private String currentCommand;
    @NotNull
    private static final Logger LOG;

    public TerminalShellIntegrationController(@NotNull Terminal terminalController) {
        Intrinsics.checkNotNullParameter((Object)terminalController, (String)"terminalController");
        EventDispatcher eventDispatcher2 = EventDispatcher.create(TerminalShellIntegrationEventsListener.class);
        Intrinsics.checkNotNullExpressionValue((Object)eventDispatcher2, (String)"create(...)");
        this.dispatcher = eventDispatcher2;
        terminalController.addCustomCommandListener(arg_0 -> TerminalShellIntegrationController._init_$lambda$0(this, arg_0));
    }

    private final void processCommandStartedEvent(List<String> args) {
        String command2;
        this.currentCommand = command2 = Param.COMMAND.getDecodedValue((String)CollectionsKt.getOrNull(args, (int)1));
        ((TerminalShellIntegrationEventsListener)this.dispatcher.getMulticaster()).commandStarted(command2);
    }

    private final void processCommandFinishedEvent(List<String> args) {
        String command2 = this.currentCommand;
        if (command2 != null) {
            this.currentCommand = null;
            int exitCode2 = Param.EXIT_CODE.getIntValue((String)CollectionsKt.getOrNull(args, (int)1));
            String currentDirectory = Param.CURRENT_DIRECTORY.getDecodedValue((String)CollectionsKt.getOrNull(args, (int)2));
            ((TerminalShellIntegrationEventsListener)this.dispatcher.getMulticaster()).commandFinished(command2, exitCode2, currentDirectory);
        }
    }

    public final void addListener(@NotNull TerminalShellIntegrationEventsListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.dispatcher.addListener((EventListener)listener2);
    }

    public final void removeListener(@NotNull TerminalShellIntegrationEventsListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.dispatcher.removeListener((EventListener)listener2);
    }

    /*
     * Unable to fully structure code
     */
    private static final void _init_$lambda$0(TerminalShellIntegrationController this$0, List args) {
        block12: {
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
            try {
                block13: {
                    block16: {
                        block14: {
                            block15: {
                                var2_2 = (String)CollectionsKt.getOrNull((List)args, (int)0);
                                if (var2_2 == null) break block13;
                                switch (var2_2.hashCode()) {
                                    case -312042330: {
                                        if (!var2_2.equals("prompt_started")) {
                                            ** break;
                                        }
                                        break block14;
                                    }
                                    case 424089318: {
                                        if (!var2_2.equals("command_finished")) {
                                            ** break;
                                        }
                                        break block15;
                                    }
                                    case -337753203: {
                                        if (var2_2.equals("command_started")) break;
                                        ** break;
                                    }
                                    case 1221126381: {
                                        if (!var2_2.equals("prompt_finished")) {
                                            ** break;
                                        }
                                        break block16;
                                    }
                                    case 1234020052: {
                                        if (!var2_2.equals("initialized")) ** break;
                                        ((TerminalShellIntegrationEventsListener)this$0.dispatcher.getMulticaster()).initialized();
                                        break block12;
                                    }
                                }
                                this$0.processCommandStartedEvent(args);
                                break block12;
                            }
                            this$0.processCommandFinishedEvent(args);
                            break block12;
                        }
                        ((TerminalShellIntegrationEventsListener)this$0.dispatcher.getMulticaster()).promptStarted();
                        break block12;
                    }
                    ((TerminalShellIntegrationEventsListener)this$0.dispatcher.getMulticaster()).promptFinished();
                    break block12;
                }
                TerminalShellIntegrationController.LOG.warn("Unknown shell integration event: " + args);
            }
            catch (Throwable t) {
                TerminalShellIntegrationController.LOG.warn("Exception during processing shell integration event: " + args, t);
            }
        }
    }

    static {
        Logger logger = Logger.getInstance(TerminalShellIntegrationController.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/terminal/backend/TerminalShellIntegrationController$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.terminal.backend"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u0001\n\u0000\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\t\u001a\u00020\bH\u0002J\u0010\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\bJ\u0010\u0010\r\u001a\u00020\b2\b\u0010\f\u001a\u0004\u0018\u00010\bJ\u0012\u0010\u000e\u001a\u0004\u0018\u00010\b2\b\u0010\f\u001a\u0004\u0018\u00010\bJ\u0012\u0010\u000f\u001a\u0004\u0018\u00010\b2\b\u0010\f\u001a\u0004\u0018\u00010\bJ\u0014\u0010\u0010\u001a\u0004\u0018\u00010\b2\b\u0010\f\u001a\u0004\u0018\u00010\bH\u0002J\u0010\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\bH\u0002J\b\u0010\u0013\u001a\u00020\u0014H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0015"}, d2={"Lcom/intellij/terminal/backend/TerminalShellIntegrationController$Param;", "", "<init>", "(Ljava/lang/String;I)V", "COMMAND", "EXIT_CODE", "CURRENT_DIRECTORY", "paramNameWithSeparator", "", "paramName", "getIntValue", "", "nameAndValue", "getDecodedValue", "getDecodedNotEmptyValueOrNull", "getDecodedValueOrNull", "getValueOrNull", "decodeHex", "hexStr", "fail", "", "intellij.terminal.backend"})
    @SourceDebugExtension(value={"SMAP\nTerminalShellIntegrationController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TerminalShellIntegrationController.kt\ncom/intellij/terminal/backend/TerminalShellIntegrationController$Param\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,100:1\n1#2:101\n*E\n"})
    private static final class Param
    extends Enum<Param> {
        @NotNull
        private final String paramNameWithSeparator = this.paramName() + "=";
        public static final /* enum */ Param COMMAND = new Param();
        public static final /* enum */ Param EXIT_CODE = new Param();
        public static final /* enum */ Param CURRENT_DIRECTORY = new Param();
        private static final /* synthetic */ Param[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private final String paramName() {
            String string = this.name();
            Locale locale = Locale.ENGLISH;
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ENGLISH");
            String string2 = string.toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
            return string2;
        }

        public final int getIntValue(@Nullable String nameAndValue) {
            Object object = this.getValueOrNull(nameAndValue);
            if (object == null || (object = StringsKt.toIntOrNull((String)object)) == null) {
                this.fail();
                throw new KotlinNothingValueException();
            }
            return (Integer)object;
        }

        @NotNull
        public final String getDecodedValue(@Nullable String nameAndValue) {
            String string = this.getDecodedValueOrNull(nameAndValue);
            if (string == null) {
                this.fail();
                throw new KotlinNothingValueException();
            }
            return string;
        }

        @Nullable
        public final String getDecodedNotEmptyValueOrNull(@Nullable String nameAndValue) {
            String string;
            String string2 = this.getDecodedValueOrNull(nameAndValue);
            if (string2 != null) {
                String string3;
                String it = string3 = string2;
                boolean bl = false;
                string = ((CharSequence)it).length() > 0 ? string3 : null;
            } else {
                string = null;
            }
            return string;
        }

        @Nullable
        public final String getDecodedValueOrNull(@Nullable String nameAndValue) {
            String string = this.getValueOrNull(nameAndValue);
            if (string == null) {
                return null;
            }
            String encodedValue = string;
            return this.decodeHex(encodedValue);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final String getValueOrNull(String nameAndValue) {
            String string;
            String string2 = nameAndValue;
            String string3 = string2;
            if (string2 == null) return null;
            String it = string = string3;
            boolean bl = false;
            if (!StringsKt.startsWith$default((String)it, (String)this.paramNameWithSeparator, (boolean)false, (int)2, null)) return null;
            String string4 = string;
            string3 = string4;
            if (string4 == null) return null;
            String string5 = string3.substring(this.paramNameWithSeparator.length());
            String string6 = string5;
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"substring(...)");
            return string6;
        }

        private final String decodeHex(String hexStr) throws IllegalArgumentException {
            byte[] bytes = HexFormat.of().parseHex(hexStr);
            Intrinsics.checkNotNull((Object)bytes);
            return new String(bytes, Charsets.UTF_8);
        }

        private final Void fail() {
            throw new IllegalStateException("Cannot parse " + this.paramName());
        }

        public static Param[] values() {
            return (Param[])$VALUES.clone();
        }

        public static Param valueOf(String value) {
            return Enum.valueOf(Param.class, value);
        }

        @NotNull
        public static EnumEntries<Param> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = paramArray = new Param[]{Param.COMMAND, Param.EXIT_CODE, Param.CURRENT_DIRECTORY};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

