/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.k2.refactoring.inline;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.usageView.UsageInfo;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.permissions.KaAnalysisPermissionRegistry;
import org.jetbrains.kotlin.idea.base.psi.KotlinPsiUtils;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.codeinsights.impl.base.inspections.OperatorToFunctionConverter;
import org.jetbrains.kotlin.idea.k2.refactoring.inline.KotlinInlineAnonymousFunctionProcessorKt;
import org.jetbrains.kotlin.idea.k2.refactoring.inline.KotlinInlineFunctionProcessorKt;
import org.jetbrains.kotlin.idea.k2.refactoring.inline.codeInliner.CodeInliner;
import org.jetbrains.kotlin.idea.k2.refactoring.inline.codeInliner.InlinePreprocessorUtilKt;
import org.jetbrains.kotlin.idea.k2.refactoring.util.LambdaToAnonymousFunctionUtil;
import org.jetbrains.kotlin.idea.refactoring.inline.AbstractKotlinDeclarationInlineProcessor;
import org.jetbrains.kotlin.idea.refactoring.inline.codeInliner.CodeToInline;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000 \u00142\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0014B)\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0013\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0014\u00a2\u0006\u0002\u0010\u000fJ\u001d\u0010\u0010\u001a\u00020\u00112\u000e\u0010\u0012\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000e0\rH\u0014\u00a2\u0006\u0002\u0010\u0013R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/idea/k2/refactoring/inline/KotlinInlineAnonymousFunctionProcessor;", "Lorg/jetbrains/kotlin/idea/refactoring/inline/AbstractKotlinDeclarationInlineProcessor;", "Lorg/jetbrains/kotlin/psi/KtFunction;", "function", "usage", "Lorg/jetbrains/kotlin/psi/KtExpression;", "editor", "Lcom/intellij/openapi/editor/Editor;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lorg/jetbrains/kotlin/psi/KtFunction;Lorg/jetbrains/kotlin/psi/KtExpression;Lcom/intellij/openapi/editor/Editor;Lcom/intellij/openapi/project/Project;)V", "findUsages", "", "Lcom/intellij/usageView/UsageInfo;", "()[Lcom/intellij/usageView/UsageInfo;", "performRefactoring", "", "usages", "([Lcom/intellij/usageView/UsageInfo;)V", "Companion", "kotlin.refactorings.k2"})
public final class KotlinInlineAnonymousFunctionProcessor
extends AbstractKotlinDeclarationInlineProcessor<KtFunction> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final KtExpression usage;

    public KotlinInlineAnonymousFunctionProcessor(@NotNull KtFunction function, @NotNull KtExpression usage, @Nullable Editor editor, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
        Intrinsics.checkNotNullParameter((Object)usage, (String)"usage");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super((KtDeclaration)function, editor, project);
        this.usage = usage;
    }

    @NotNull
    protected UsageInfo[] findUsages() {
        UsageInfo[] usageInfoArray = new UsageInfo[]{new UsageInfo((PsiElement)this.usage)};
        return usageInfoArray;
    }

    protected void performRefactoring(@NotNull UsageInfo[] usages2) {
        Intrinsics.checkNotNullParameter((Object)usages2, (String)"usages");
        Companion.performRefactoring(this.usage, this.getEditor());
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00052\b\u0010\u000b\u001a\u0004\u0018\u00010\fJ\u0012\u0010\r\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J'\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u000b\u0010\u0015\u001a\u00070\u0016\u00a2\u0006\u0002\b\u0017H\u0002\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/idea/k2/refactoring/inline/KotlinInlineAnonymousFunctionProcessor$Companion;", "", "<init>", "()V", "findCallExpression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "function", "Lorg/jetbrains/kotlin/psi/KtFunction;", "performRefactoring", "", "usage", "editor", "Lcom/intellij/openapi/editor/Editor;", "findFunction", "qualifiedExpression", "Lorg/jetbrains/kotlin/psi/KtQualifiedExpression;", "convertFunctionToAnonymousFunction", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "showErrorHint", "project", "Lcom/intellij/openapi/project/Project;", "message", "", "Lcom/intellij/openapi/util/NlsContexts$DialogMessage;", "kotlin.refactorings.k2"})
    @SourceDebugExtension(value={"SMAP\nKotlinInlineAnonymousFunctionProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinInlineAnonymousFunctionProcessor.kt\norg/jetbrains/kotlin/idea/k2/refactoring/inline/KotlinInlineAnonymousFunctionProcessor$Companion\n+ 2 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n+ 3 permissions.kt\norg/jetbrains/kotlin/analysis/api/permissions/PermissionsKt\n*L\n1#1,136:1\n125#2:137\n41#3,2:138\n102#3,8:140\n44#3,3:148\n102#3,8:151\n48#3:159\n41#3,2:160\n102#3,8:162\n44#3,3:170\n102#3,8:173\n48#3:181\n*S KotlinDebug\n*F\n+ 1 KotlinInlineAnonymousFunctionProcessor.kt\norg/jetbrains/kotlin/idea/k2/refactoring/inline/KotlinInlineAnonymousFunctionProcessor$Companion\n*L\n58#1:137\n77#1:138,2\n78#1:140,8\n77#1:148,3\n78#1:151,8\n77#1:159\n106#1:160,2\n107#1:162,8\n106#1:170,3\n107#1:173,8\n106#1:181\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final KtExpression findCallExpression(@NotNull KtFunction function) {
            Object object;
            KtExpression psiElement;
            Intrinsics.checkNotNullParameter((Object)function, (String)"function");
            PsiElement psiElement2 = (PsiElement)SequencesKt.lastOrNull((Sequence)SequencesKt.takeWhile((Sequence)PsiUtilsKt.getParents((PsiElement)((PsiElement)function)), Companion::findCallExpression$lambda$0));
            PsiElement psiElement3 = psiElement2 != null ? psiElement2.getParent() : null;
            KtExpression ktExpression = psiElement = psiElement3 instanceof KtExpression ? (KtExpression)psiElement3 : null;
            if (ktExpression != null) {
                PsiElement it = psiElement3 = ktExpression;
                boolean bl = false;
                object = it instanceof KtCallExpression || it instanceof KtQualifiedExpression && KotlinInlineAnonymousFunctionProcessorKt.access$isInvokeCall(((KtQualifiedExpression)it).getSelectorExpression()) ? psiElement3 : null;
            } else {
                object = null;
            }
            return object;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void performRefactoring(@NotNull KtExpression usage, @Nullable Editor editor) {
            PsiElement psiElement;
            Intrinsics.checkNotNullParameter((Object)usage, (String)"usage");
            Project project = usage.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            Project project2 = project;
            KtExpression ktExpression = usage;
            if (ktExpression instanceof KtQualifiedExpression) {
                psiElement = (PsiElement)((KtQualifiedExpression)usage).getSelectorExpression();
            } else if (ktExpression instanceof KtCallExpression) {
                psiElement = ((KtSimpleNameExpression)OperatorToFunctionConverter.INSTANCE.convert(usage).getSecond()).getParent();
            } else {
                return;
            }
            PsiElement psiElement2 = psiElement;
            Intrinsics.checkNotNull((Object)psiElement2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtCallExpression");
            KtCallExpression invokeCallExpression = (KtCallExpression)psiElement2;
            KtExpression ktExpression2 = invokeCallExpression.getCalleeExpression();
            if (ktExpression2 != null) {
                KtExpression $this$safeAs$iv = ktExpression2;
                boolean $i$f$safeAs = false;
                KtExpression ktExpression3 = $this$safeAs$iv;
                if (!(ktExpression3 instanceof KtReferenceExpression)) {
                    ktExpression3 = null;
                }
                if ((ktExpression2 = (KtReferenceExpression)ktExpression3) != null) {
                    KtExpression it = ktExpression2;
                    boolean bl = false;
                    InlinePreprocessorUtilKt.fullyExpandCall((KtReferenceExpression)it);
                }
            }
            PsiElement psiElement3 = invokeCallExpression.getParent();
            Intrinsics.checkNotNull((Object)psiElement3, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtQualifiedExpression");
            KtQualifiedExpression qualifiedExpression = (KtQualifiedExpression)psiElement3;
            KtFunction ktFunction = this.findFunction(qualifiedExpression);
            if (ktFunction == null) {
                this.showErrorHint(project2, editor, KotlinBundle.message((String)"refactoring.the.function.not.found", (Object[])new Object[0]));
                return;
            }
            KtFunction functionLiteral = ktFunction;
            KtNamedFunction ktNamedFunction = this.convertFunctionToAnonymousFunction(functionLiteral);
            if (ktNamedFunction == null) {
                this.showErrorHint(project2, editor, KotlinBundle.message((String)"refactoring.the.function.cannot.be.converted.to.anonymous.function", (Object[])new Object[0]));
                return;
            }
            KtNamedFunction function = ktNamedFunction;
            CodeToInline codeToInline = KotlinInlineFunctionProcessorKt.createCodeToInlineForFunction$default(function, editor, false, 4, null);
            if (codeToInline == null) {
                return;
            }
            CodeToInline codeToInline2 = codeToInline;
            boolean $i$f$allowAnalysisOnEdt = false;
            KaAnalysisPermissionRegistry permissionRegistry$iv = KaAnalysisPermissionRegistry.Companion.getInstance();
            if (permissionRegistry$iv.isAnalysisAllowedOnEdt()) {
                boolean bl = false;
                boolean $i$f$allowAnalysisFromWriteAction = false;
                KaAnalysisPermissionRegistry permissionRegistry$iv2 = KaAnalysisPermissionRegistry.Companion.getInstance();
                if (permissionRegistry$iv2.isAnalysisAllowedInWriteAction()) {
                    boolean bl2 = false;
                    new CodeInliner(null, (KtElement)invokeCallExpression, false, codeToInline2).doInline();
                } else {
                    permissionRegistry$iv2.setAnalysisAllowedInWriteAction(true);
                    try {
                        boolean bl3 = false;
                        KtElement ktElement = new CodeInliner(null, (KtElement)invokeCallExpression, false, codeToInline2).doInline();
                    }
                    finally {
                        permissionRegistry$iv2.setAnalysisAllowedInWriteAction(false);
                    }
                }
            } else {
                permissionRegistry$iv.setAnalysisAllowedOnEdt(true);
                try {
                    KtElement ktElement;
                    boolean bl = false;
                    boolean $i$f$allowAnalysisFromWriteAction = false;
                    KaAnalysisPermissionRegistry permissionRegistry$iv3 = KaAnalysisPermissionRegistry.Companion.getInstance();
                    if (permissionRegistry$iv3.isAnalysisAllowedInWriteAction()) {
                        boolean bl4 = false;
                        ktElement = new CodeInliner(null, (KtElement)invokeCallExpression, false, codeToInline2).doInline();
                    } else {
                        permissionRegistry$iv3.setAnalysisAllowedInWriteAction(true);
                        try {
                            boolean bl5 = false;
                            KtElement ktElement2 = new CodeInliner(null, (KtElement)invokeCallExpression, false, codeToInline2).doInline();
                            ktElement = ktElement2;
                        }
                        finally {
                            permissionRegistry$iv3.setAnalysisAllowedInWriteAction(false);
                        }
                    }
                    KtElement ktElement3 = ktElement;
                }
                finally {
                    permissionRegistry$iv.setAnalysisAllowedOnEdt(false);
                }
            }
        }

        private final KtFunction findFunction(KtQualifiedExpression qualifiedExpression) {
            KtFunction ktFunction;
            KtExpression expression = KotlinPsiUtils.safeDeparenthesize(qualifiedExpression.getReceiverExpression());
            if (expression instanceof KtLambdaExpression) {
                ktFunction = (KtFunction)((KtLambdaExpression)expression).getFunctionLiteral();
            } else if (expression instanceof KtNamedFunction) {
                ktFunction = (KtFunction)expression;
            } else if (expression instanceof KtDotQualifiedExpression) {
                KtExpression ktExpression = ((KtDotQualifiedExpression)expression).getSelectorExpression();
                if (ktExpression != null) {
                    KtExpression expr = ktExpression;
                    boolean bl = false;
                    KtExpression deparenthesize = KotlinPsiUtils.safeDeparenthesize(expr);
                    KtLambdaExpression ktLambdaExpression = deparenthesize instanceof KtLambdaExpression ? (KtLambdaExpression)deparenthesize : null;
                    ktFunction = (KtFunction)(ktLambdaExpression != null && (ktLambdaExpression = ktLambdaExpression.getFunctionLiteral()) != null ? (NavigatablePsiElement)ktLambdaExpression : (NavigatablePsiElement)(deparenthesize instanceof KtNamedFunction ? (KtNamedFunction)deparenthesize : null));
                } else {
                    ktFunction = null;
                }
            } else {
                ktFunction = null;
            }
            return ktFunction;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final KtNamedFunction convertFunctionToAnonymousFunction(KtFunction function) {
            Object object;
            KtFunction ktFunction = function;
            if (ktFunction instanceof KtNamedFunction) {
                object = (KtNamedFunction)function;
            } else if (ktFunction instanceof KtFunctionLiteral) {
                String string;
                PsiElement psiElement = ((KtFunctionLiteral)function).getParent();
                KtLambdaExpression ktLambdaExpression = psiElement instanceof KtLambdaExpression ? (KtLambdaExpression)psiElement : null;
                if (ktLambdaExpression == null) {
                    return null;
                }
                KtLambdaExpression lambdaExpression = ktLambdaExpression;
                boolean $i$f$allowAnalysisOnEdt = false;
                KaAnalysisPermissionRegistry permissionRegistry$iv = KaAnalysisPermissionRegistry.Companion.getInstance();
                if (permissionRegistry$iv.isAnalysisAllowedOnEdt()) {
                    boolean bl = false;
                    boolean $i$f$allowAnalysisFromWriteAction = false;
                    KaAnalysisPermissionRegistry permissionRegistry$iv2 = KaAnalysisPermissionRegistry.Companion.getInstance();
                    if (permissionRegistry$iv2.isAnalysisAllowedInWriteAction()) {
                        boolean bl2 = false;
                        string = LambdaToAnonymousFunctionUtil.prepareFunctionText$default(LambdaToAnonymousFunctionUtil.INSTANCE, lambdaExpression, null, 2, null);
                    } else {
                        permissionRegistry$iv2.setAnalysisAllowedInWriteAction(true);
                        try {
                            boolean $i$a$-allowAnalysisFromWriteAction-KotlinInlineAnonymousFunctionProcessor$Companion$convertFunctionToAnonymousFunction$signature$1$22 = false;
                            String $i$a$-allowAnalysisFromWriteAction-KotlinInlineAnonymousFunctionProcessor$Companion$convertFunctionToAnonymousFunction$signature$1$22 = LambdaToAnonymousFunctionUtil.prepareFunctionText$default(LambdaToAnonymousFunctionUtil.INSTANCE, lambdaExpression, null, 2, null);
                            string = $i$a$-allowAnalysisFromWriteAction-KotlinInlineAnonymousFunctionProcessor$Companion$convertFunctionToAnonymousFunction$signature$1$22;
                        }
                        finally {
                            permissionRegistry$iv2.setAnalysisAllowedInWriteAction(false);
                        }
                    }
                } else {
                    permissionRegistry$iv.setAnalysisAllowedOnEdt(true);
                    try {
                        String string2;
                        boolean bl = false;
                        boolean $i$f$allowAnalysisFromWriteAction = false;
                        KaAnalysisPermissionRegistry permissionRegistry$iv3 = KaAnalysisPermissionRegistry.Companion.getInstance();
                        if (permissionRegistry$iv3.isAnalysisAllowedInWriteAction()) {
                            boolean bl3 = false;
                            string2 = LambdaToAnonymousFunctionUtil.prepareFunctionText$default(LambdaToAnonymousFunctionUtil.INSTANCE, lambdaExpression, null, 2, null);
                        } else {
                            permissionRegistry$iv3.setAnalysisAllowedInWriteAction(true);
                            try {
                                boolean bl4 = false;
                                String string3 = LambdaToAnonymousFunctionUtil.prepareFunctionText$default(LambdaToAnonymousFunctionUtil.INSTANCE, lambdaExpression, null, 2, null);
                                string2 = string3;
                            }
                            finally {
                                permissionRegistry$iv3.setAnalysisAllowedInWriteAction(false);
                            }
                        }
                        String string4 = string2;
                        string = string4;
                    }
                    finally {
                        permissionRegistry$iv.setAnalysisAllowedOnEdt(false);
                    }
                }
                if (string == null) {
                    return null;
                }
                String signature = string;
                psiElement = LambdaToAnonymousFunctionUtil.INSTANCE.convertLambdaToFunction(lambdaExpression, signature);
                object = psiElement instanceof KtNamedFunction ? (KtNamedFunction)psiElement : null;
            } else {
                object = null;
            }
            return object;
        }

        private final void showErrorHint(Project project, Editor editor, String message2) {
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message2, (String)KotlinBundle.message((String)"title.inline.function", (Object[])new Object[0]), (String)"refactoring.inlineMethod");
        }

        private static final boolean findCallExpression$lambda$0(PsiElement it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return it instanceof KtParenthesizedExpression || it instanceof KtLambdaExpression;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

