/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections.dfa;

import com.intellij.codeInspection.dataFlow.DfaNullability;
import com.intellij.codeInspection.dataFlow.TypeConstraint;
import com.intellij.codeInspection.dataFlow.TypeConstraints;
import com.intellij.codeInspection.dataFlow.jvm.SpecialField;
import com.intellij.codeInspection.dataFlow.rangeSet.LongRangeBinOp;
import com.intellij.codeInspection.dataFlow.rangeSet.LongRangeSet;
import com.intellij.codeInspection.dataFlow.types.DfBooleanConstantType;
import com.intellij.codeInspection.dataFlow.types.DfBooleanType;
import com.intellij.codeInspection.dataFlow.types.DfDoubleConstantType;
import com.intellij.codeInspection.dataFlow.types.DfDoubleType;
import com.intellij.codeInspection.dataFlow.types.DfFloatConstantType;
import com.intellij.codeInspection.dataFlow.types.DfFloatType;
import com.intellij.codeInspection.dataFlow.types.DfIntConstantType;
import com.intellij.codeInspection.dataFlow.types.DfIntType;
import com.intellij.codeInspection.dataFlow.types.DfLongConstantType;
import com.intellij.codeInspection.dataFlow.types.DfLongType;
import com.intellij.codeInspection.dataFlow.types.DfNullConstantType;
import com.intellij.codeInspection.dataFlow.types.DfPrimitiveType;
import com.intellij.codeInspection.dataFlow.types.DfReferenceType;
import com.intellij.codeInspection.dataFlow.types.DfType;
import com.intellij.codeInspection.dataFlow.types.DfTypes;
import com.intellij.codeInspection.dataFlow.value.RelationType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.tree.IElementType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.TypeAliasDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ExtendedResolutionApiKt;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.codeInsight.hints.RangeKtExpressionType;
import org.jetbrains.kotlin.idea.inspections.dfa.KtClassDef;
import org.jetbrains.kotlin.idea.inspections.dfa.LambdaAndParameter;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.FqNameUnsafe;
import org.jetbrains.kotlin.psi.KtBinaryExpressionWithTypeRHS;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtLambdaArgument;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtOperationReferenceExpression;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtSuperTypeListEntry;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.bindingContextUtil.BindingContextUtilsKt;
import org.jetbrains.kotlin.resolve.calls.model.ArgumentMapping;
import org.jetbrains.kotlin.resolve.calls.model.ArgumentMatch;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.constants.BooleanValue;
import org.jetbrains.kotlin.resolve.constants.ByteValue;
import org.jetbrains.kotlin.resolve.constants.CharValue;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.DoubleValue;
import org.jetbrains.kotlin.resolve.constants.FloatValue;
import org.jetbrains.kotlin.resolve.constants.IntValue;
import org.jetbrains.kotlin.resolve.constants.LongValue;
import org.jetbrains.kotlin.resolve.constants.NullValue;
import org.jetbrains.kotlin.resolve.constants.ShortValue;
import org.jetbrains.kotlin.resolve.constants.evaluate.ConstantExpressionEvaluator;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.resolve.source.KotlinSourceElement;
import org.jetbrains.kotlin.types.FlexibleTypesKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000h\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0000\u001a\u00020\u0001*\u0004\u0018\u00010\u0002H\u0000\u001a\f\u0010\u0003\u001a\u00020\u0001*\u00020\u0002H\u0002\u001a\f\u0010\u0004\u001a\u00020\u0005*\u00020\u0006H\u0002\u001a\u0016\u0010\u0007\u001a\u00020\b*\u0004\u0018\u00010\u00022\u0006\u0010\t\u001a\u00020\nH\u0000\u001a\f\u0010\u000b\u001a\u00020\b*\u00020\u0002H\u0000\u001a\u0010\u0010\f\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u000eH\u0000\u001a\u000e\u0010\u000f\u001a\u0004\u0018\u00010\u0002*\u00020\u0010H\u0000\u001a\u000e\u0010\u0011\u001a\u0004\u0018\u00010\u0002*\u00020\u0002H\u0000\u001a\f\u0010\u0012\u001a\u00020\u0013*\u00020\u0002H\u0000\u001a\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0000\u001a\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0000\u001a\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u0016\u001a\u00020\u0017H\u0000\u001a\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\r\u001a\u00020\u001fH\u0000\u001a\u0018\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00150!*\u00020\"H\u0000\u00a8\u0006#"}, d2={"toDfType", "Lcom/intellij/codeInspection/dataFlow/types/DfType;", "Lorg/jetbrains/kotlin/types/KotlinType;", "toDfTypeNotNullable", "getTypeConstraint", "Lcom/intellij/codeInspection/dataFlow/TypeConstraint;", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "fqNameEquals", "", "fqName", "", "canBeNull", "getConstant", "expr", "Lorg/jetbrains/kotlin/psi/KtConstantExpression;", "getKotlinType", "Lorg/jetbrains/kotlin/psi/KtExpression;", "getArrayElementType", "toPsiPrimitiveType", "Lcom/intellij/psi/PsiPrimitiveType;", "relationFromToken", "Lcom/intellij/codeInspection/dataFlow/value/RelationType;", "token", "Lcom/intellij/psi/tree/IElementType;", "mathOpFromToken", "Lcom/intellij/codeInspection/dataFlow/rangeSet/LongRangeBinOp;", "ref", "Lorg/jetbrains/kotlin/psi/KtOperationReferenceExpression;", "mathOpFromAssignmentToken", "getInlineableLambda", "Lorg/jetbrains/kotlin/idea/inspections/dfa/LambdaAndParameter;", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "getRelationType", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/idea/codeInsight/hints/RangeKtExpressionType;", "kotlin.idea"})
@SourceDebugExtension(value={"SMAP\nKtDfaHelpers.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KtDfaHelpers.kt\norg/jetbrains/kotlin/idea/inspections/dfa/KtDfaHelpersKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,274:1\n1563#2:275\n1634#2,3:276\n1803#2,3:279\n1563#2:282\n1634#2,3:283\n*S KotlinDebug\n*F\n+ 1 KtDfaHelpers.kt\norg/jetbrains/kotlin/idea/inspections/dfa/KtDfaHelpersKt\n*L\n91#1:275\n91#1:276,3\n91#1:279,3\n105#1:282\n105#1:283,3\n*E\n"})
public final class KtDfaHelpersKt {
    @NotNull
    public static final DfType toDfType(@Nullable KotlinType $this$toDfType) {
        if ($this$toDfType == null) {
            DfType dfType = DfType.TOP;
            Intrinsics.checkNotNullExpressionValue((Object)dfType, (String)"TOP");
            return dfType;
        }
        if (KtDfaHelpersKt.canBeNull($this$toDfType)) {
            DfType dfType;
            DfType dfType2;
            ClassifierDescriptor classifierDescriptor;
            DfType notNullableType = KtDfaHelpersKt.toDfTypeNotNullable(TypeUtilsKt.makeNotNullable((KotlinType)$this$toDfType));
            if (notNullableType instanceof DfPrimitiveType) {
                classifierDescriptor = $this$toDfType.getConstructor().getDeclarationDescriptor();
                ClassDescriptor cls = classifierDescriptor instanceof ClassDescriptor ? (ClassDescriptor)classifierDescriptor : null;
                DfType boxedType = null;
                if (cls != null) {
                    DfType dfType3 = TypeConstraints.exactClass((TypeConstraints.ClassDef)new KtClassDef(cls)).asDfType();
                    Intrinsics.checkNotNullExpressionValue((Object)dfType3, (String)"asDfType(...)");
                    boxedType = dfType3;
                } else {
                    DfReferenceType dfReferenceType = DfTypes.OBJECT_OR_NULL;
                    Intrinsics.checkNotNullExpressionValue((Object)dfReferenceType, (String)"OBJECT_OR_NULL");
                    boxedType = (DfType)dfReferenceType;
                }
                DfType dfType4 = SpecialField.UNBOX.asDfType(notNullableType).meet(boxedType);
                Intrinsics.checkNotNullExpressionValue((Object)dfType4, (String)"meet(...)");
                notNullableType = dfType4;
            }
            if ((dfType2 = notNullableType) instanceof DfReferenceType) {
                classifierDescriptor = ((DfReferenceType)notNullableType).dropNullability().meet((DfType)DfaNullability.NULLABLE.asDfType());
                Intrinsics.checkNotNull((Object)classifierDescriptor);
                dfType = classifierDescriptor;
            } else if (Intrinsics.areEqual((Object)dfType2, (Object)DfType.BOTTOM)) {
                classifierDescriptor = DfTypes.NULL;
                Intrinsics.checkNotNull((Object)classifierDescriptor);
                dfType = (DfType)classifierDescriptor;
            } else {
                dfType = notNullableType;
            }
            return dfType;
        }
        return KtDfaHelpersKt.toDfTypeNotNullable($this$toDfType);
    }

    /*
     * WARNING - void declaration
     */
    private static final DfType toDfTypeNotNullable(KotlinType $this$toDfTypeNotNullable) {
        DfType dfType;
        ClassifierDescriptor descriptor2 = $this$toDfTypeNotNullable.getConstructor().getDeclarationDescriptor();
        if (descriptor2 instanceof TypeAliasDescriptor) {
            dfType = KtDfaHelpersKt.toDfType((KotlinType)((TypeAliasDescriptor)descriptor2).getExpandedType());
        } else if (descriptor2 instanceof ClassDescriptor) {
            FqNameUnsafe fqNameUnsafe = DescriptorUtilsKt.getFqNameUnsafe((DeclarationDescriptor)((DeclarationDescriptor)descriptor2));
            if (Intrinsics.areEqual((Object)fqNameUnsafe, (Object)StandardNames.FqNames._boolean)) {
                DfBooleanType dfBooleanType = DfTypes.BOOLEAN;
                Intrinsics.checkNotNullExpressionValue((Object)dfBooleanType, (String)"BOOLEAN");
                dfType = (DfType)dfBooleanType;
            } else if (Intrinsics.areEqual((Object)fqNameUnsafe, (Object)StandardNames.FqNames._byte)) {
                DfType dfType2 = DfTypes.intRange((LongRangeSet)LongRangeSet.range((long)-128L, (long)127L));
                dfType = dfType2;
                Intrinsics.checkNotNullExpressionValue((Object)dfType2, (String)"intRange(...)");
            } else if (Intrinsics.areEqual((Object)fqNameUnsafe, (Object)StandardNames.FqNames._char)) {
                DfType dfType3 = DfTypes.intRange((LongRangeSet)LongRangeSet.range((long)0L, (long)65535L));
                dfType = dfType3;
                Intrinsics.checkNotNullExpressionValue((Object)dfType3, (String)"intRange(...)");
            } else if (Intrinsics.areEqual((Object)fqNameUnsafe, (Object)StandardNames.FqNames._short)) {
                DfType dfType4 = DfTypes.intRange((LongRangeSet)LongRangeSet.range((long)-32768L, (long)32767L));
                dfType = dfType4;
                Intrinsics.checkNotNullExpressionValue((Object)dfType4, (String)"intRange(...)");
            } else if (Intrinsics.areEqual((Object)fqNameUnsafe, (Object)StandardNames.FqNames._int)) {
                DfIntType dfIntType = DfTypes.INT;
                Intrinsics.checkNotNullExpressionValue((Object)dfIntType, (String)"INT");
                dfType = (DfType)dfIntType;
            } else if (Intrinsics.areEqual((Object)fqNameUnsafe, (Object)StandardNames.FqNames._long)) {
                DfLongType dfLongType = DfTypes.LONG;
                Intrinsics.checkNotNullExpressionValue((Object)dfLongType, (String)"LONG");
                dfType = (DfType)dfLongType;
            } else if (Intrinsics.areEqual((Object)fqNameUnsafe, (Object)StandardNames.FqNames._float)) {
                DfFloatType dfFloatType = DfTypes.FLOAT;
                Intrinsics.checkNotNullExpressionValue((Object)dfFloatType, (String)"FLOAT");
                dfType = (DfType)dfFloatType;
            } else if (Intrinsics.areEqual((Object)fqNameUnsafe, (Object)StandardNames.FqNames._double)) {
                DfDoubleType dfDoubleType = DfTypes.DOUBLE;
                Intrinsics.checkNotNullExpressionValue((Object)dfDoubleType, (String)"DOUBLE");
                dfType = (DfType)dfDoubleType;
            } else if (Intrinsics.areEqual((Object)fqNameUnsafe, (Object)StandardNames.FqNames.array)) {
                KotlinType kotlinType = KtDfaHelpersKt.getArrayElementType($this$toDfTypeNotNullable);
                ClassifierDescriptor classifierDescriptor = kotlinType != null && (kotlinType = kotlinType.getConstructor()) != null ? kotlinType.getDeclarationDescriptor() : null;
                ClassDescriptor classDescriptor = classifierDescriptor instanceof ClassDescriptor ? (ClassDescriptor)classifierDescriptor : null;
                if (classDescriptor == null) {
                    DfType dfType5 = DfType.TOP;
                    Intrinsics.checkNotNullExpressionValue((Object)dfType5, (String)"TOP");
                    return dfType5;
                }
                ClassDescriptor elementType = classDescriptor;
                DfType dfType6 = KtDfaHelpersKt.getTypeConstraint(elementType).arrayOf().asDfType().meet((DfType)DfTypes.NOT_NULL_OBJECT);
                Intrinsics.checkNotNull((Object)dfType6);
                dfType = dfType6;
            } else if (Intrinsics.areEqual((Object)fqNameUnsafe, (Object)StandardNames.FqNames.any)) {
                DfReferenceType dfReferenceType = DfTypes.NOT_NULL_OBJECT;
                Intrinsics.checkNotNullExpressionValue((Object)dfReferenceType, (String)"NOT_NULL_OBJECT");
                dfType = (DfType)dfReferenceType;
            } else {
                DfType dfType7 = KtDfaHelpersKt.getTypeConstraint((ClassDescriptor)descriptor2).asDfType().meet((DfType)DfTypes.NOT_NULL_OBJECT);
                dfType = dfType7;
                Intrinsics.checkNotNullExpressionValue((Object)dfType7, (String)"meet(...)");
            }
        } else if (descriptor2 instanceof TypeParameterDescriptor) {
            void $this$fold$iv;
            void $this$mapTo$iv$iv;
            List list2 = ((TypeParameterDescriptor)descriptor2).getUpperBounds();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getUpperBounds(...)");
            Iterable $this$map$iv = list2;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void type2;
                KotlinType kotlinType = (KotlinType)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(KtDfaHelpersKt.toDfType((KotlinType)type2));
            }
            $this$map$iv = (List)destination$iv$iv;
            DfType initial$iv = DfType.TOP;
            boolean $i$f$fold = false;
            DfType accumulator$iv = initial$iv;
            for (Object element$iv : $this$fold$iv) {
                void p1;
                Object item$iv$iv;
                item$iv$iv = (DfType)element$iv;
                DfType p0 = accumulator$iv;
                boolean bl = false;
                accumulator$iv = p0.meet((DfType)p1);
            }
            DfType dfType8 = accumulator$iv;
            dfType = dfType8;
            Intrinsics.checkNotNullExpressionValue((Object)dfType8, (String)"fold(...)");
        } else {
            DfType dfType9 = DfType.TOP;
            dfType = dfType9;
            Intrinsics.checkNotNullExpressionValue((Object)dfType9, (String)"TOP");
        }
        return dfType;
    }

    /*
     * WARNING - void declaration
     */
    private static final TypeConstraint getTypeConstraint(ClassDescriptor $this$getTypeConstraint) {
        TypeConstraint typeConstraint;
        FqNameUnsafe fqNameUnsafe = DescriptorUtilsKt.getFqNameUnsafe((DeclarationDescriptor)((DeclarationDescriptor)$this$getTypeConstraint));
        if (fqNameUnsafe.shortNameOrSpecial().isSpecial()) {
            KtElement psi;
            SourceElement sourceElement = $this$getTypeConstraint.getSource();
            Intrinsics.checkNotNullExpressionValue((Object)sourceElement, (String)"getSource(...)");
            SourceElement source = sourceElement;
            if (source instanceof KotlinSourceElement && (psi = ((KotlinSourceElement)source).getPsi()) instanceof KtObjectDeclaration) {
                TypeConstraint typeConstraint2;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                BindingContext bindingContext = ExtendedResolutionApiKt.safeAnalyzeNonSourceRootCode$default(psi, null, 1, null);
                Iterable iterable = ((KtObjectDeclaration)psi).getSuperTypeListEntries();
                boolean $i$f$map = false;
                void var8_9 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    TypeConstructor typeConstructor;
                    KotlinType kotlinType;
                    void entry;
                    KtSuperTypeListEntry ktSuperTypeListEntry = (KtSuperTypeListEntry)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    KtTypeReference ktTypeReference = entry.getTypeReference();
                    ClassifierDescriptor classifierDescriptor = ktTypeReference != null && (kotlinType = BindingContextUtilsKt.getAbbreviatedTypeOrType((KtTypeReference)ktTypeReference, (BindingContext)bindingContext)) != null && (typeConstructor = kotlinType.getConstructor()) != null ? typeConstructor.getDeclarationDescriptor() : null;
                    ClassDescriptor classDescriptor = classifierDescriptor instanceof ClassDescriptor ? (ClassDescriptor)classifierDescriptor : null;
                    collection.add(classDescriptor == null ? null : new KtClassDef(classDescriptor));
                }
                List superTypes2 = (List)destination$iv$iv;
                if (superTypes2.contains(null)) {
                    TypeConstraint typeConstraint3 = TypeConstraints.TOP;
                    typeConstraint2 = typeConstraint3;
                    Intrinsics.checkNotNullExpressionValue((Object)typeConstraint3, (String)"TOP");
                } else {
                    TypeConstraint typeConstraint4 = TypeConstraints.exactSubtype((PsiElement)((PsiElement)psi), (List)superTypes2);
                    typeConstraint2 = typeConstraint4;
                    Intrinsics.checkNotNullExpressionValue((Object)typeConstraint4, (String)"exactSubtype(...)");
                }
                return typeConstraint2;
            }
        }
        switch (fqNameUnsafe.asString()) {
            case "kotlin.ByteArray": {
                TypeConstraint typeConstraint5 = TypeConstraints.exact((PsiType)((PsiType)PsiTypes.byteType().createArrayType()));
                typeConstraint = typeConstraint5;
                Intrinsics.checkNotNullExpressionValue((Object)typeConstraint5, (String)"exact(...)");
                break;
            }
            case "kotlin.IntArray": {
                TypeConstraint typeConstraint6 = TypeConstraints.exact((PsiType)((PsiType)PsiTypes.intType().createArrayType()));
                typeConstraint = typeConstraint6;
                Intrinsics.checkNotNullExpressionValue((Object)typeConstraint6, (String)"exact(...)");
                break;
            }
            case "kotlin.LongArray": {
                TypeConstraint typeConstraint7 = TypeConstraints.exact((PsiType)((PsiType)PsiTypes.longType().createArrayType()));
                typeConstraint = typeConstraint7;
                Intrinsics.checkNotNullExpressionValue((Object)typeConstraint7, (String)"exact(...)");
                break;
            }
            case "kotlin.ShortArray": {
                TypeConstraint typeConstraint8 = TypeConstraints.exact((PsiType)((PsiType)PsiTypes.shortType().createArrayType()));
                typeConstraint = typeConstraint8;
                Intrinsics.checkNotNullExpressionValue((Object)typeConstraint8, (String)"exact(...)");
                break;
            }
            case "kotlin.CharArray": {
                TypeConstraint typeConstraint9 = TypeConstraints.exact((PsiType)((PsiType)PsiTypes.charType().createArrayType()));
                typeConstraint = typeConstraint9;
                Intrinsics.checkNotNullExpressionValue((Object)typeConstraint9, (String)"exact(...)");
                break;
            }
            case "kotlin.BooleanArray": {
                TypeConstraint typeConstraint10 = TypeConstraints.exact((PsiType)((PsiType)PsiTypes.booleanType().createArrayType()));
                typeConstraint = typeConstraint10;
                Intrinsics.checkNotNullExpressionValue((Object)typeConstraint10, (String)"exact(...)");
                break;
            }
            case "kotlin.FloatArray": {
                TypeConstraint typeConstraint11 = TypeConstraints.exact((PsiType)((PsiType)PsiTypes.floatType().createArrayType()));
                typeConstraint = typeConstraint11;
                Intrinsics.checkNotNullExpressionValue((Object)typeConstraint11, (String)"exact(...)");
                break;
            }
            case "kotlin.DoubleArray": {
                TypeConstraint typeConstraint12 = TypeConstraints.exact((PsiType)((PsiType)PsiTypes.doubleType().createArrayType()));
                typeConstraint = typeConstraint12;
                Intrinsics.checkNotNullExpressionValue((Object)typeConstraint12, (String)"exact(...)");
                break;
            }
            default: {
                KtClassDef classDef = new KtClassDef($this$getTypeConstraint);
                if ($this$getTypeConstraint.getKind() == ClassKind.OBJECT) {
                    TypeConstraint.Exact exact = TypeConstraints.singleton((TypeConstraints.ClassDef)classDef);
                    Intrinsics.checkNotNull((Object)exact);
                    typeConstraint = (TypeConstraint)exact;
                    break;
                }
                TypeConstraint typeConstraint13 = TypeConstraints.exactClass((TypeConstraints.ClassDef)classDef).instanceOf();
                Intrinsics.checkNotNull((Object)typeConstraint13);
                typeConstraint = typeConstraint13;
            }
        }
        return typeConstraint;
    }

    public static final boolean fqNameEquals(@Nullable KotlinType $this$fqNameEquals, @NotNull String fqName2) {
        ClassifierDescriptor classifierDescriptor;
        Intrinsics.checkNotNullParameter((Object)fqName2, (String)"fqName");
        return $this$fqNameEquals != null && Intrinsics.areEqual((classifierDescriptor = $this$fqNameEquals.getConstructor().getDeclarationDescriptor()) != null && (classifierDescriptor = DescriptorUtilsKt.getFqNameUnsafe((DeclarationDescriptor)((DeclarationDescriptor)classifierDescriptor))) != null ? classifierDescriptor.asString() : null, (Object)fqName2);
    }

    public static final boolean canBeNull(@NotNull KotlinType $this$canBeNull) {
        Intrinsics.checkNotNullParameter((Object)$this$canBeNull, (String)"<this>");
        return $this$canBeNull.isMarkedNullable() || FlexibleTypesKt.isNullabilityFlexible((KotlinType)$this$canBeNull);
    }

    @NotNull
    public static final DfType getConstant(@NotNull KtConstantExpression expr) {
        DfType dfType;
        ConstantValue constant;
        Object object;
        Intrinsics.checkNotNullParameter((Object)expr, (String)"expr");
        BindingContext bindingContext = ExtendedResolutionApiKt.safeAnalyzeNonSourceRootCode((KtElement)expr, BodyResolveMode.PARTIAL);
        KotlinType type2 = bindingContext.getType((KtExpression)expr);
        if (type2 == null) {
            object = null;
        } else {
            CompileTimeConstant compileTimeConstant = ConstantExpressionEvaluator.Companion.getConstant((KtExpression)expr, bindingContext);
            object = compileTimeConstant != null ? compileTimeConstant.toConstantValue(type2) : null;
        }
        ConstantValue constantValue = constant = object;
        if (constantValue instanceof NullValue) {
            DfNullConstantType dfNullConstantType = DfTypes.NULL;
            Intrinsics.checkNotNullExpressionValue((Object)dfNullConstantType, (String)"NULL");
            dfType = (DfType)dfNullConstantType;
        } else if (constantValue instanceof BooleanValue) {
            DfBooleanConstantType dfBooleanConstantType = DfTypes.booleanValue((boolean)((Boolean)((BooleanValue)constant).getValue()));
            Intrinsics.checkNotNullExpressionValue((Object)dfBooleanConstantType, (String)"booleanValue(...)");
            dfType = (DfType)dfBooleanConstantType;
        } else if (constantValue instanceof ByteValue) {
            DfIntConstantType dfIntConstantType = DfTypes.intValue((int)((Number)((ByteValue)constant).getValue()).byteValue());
            Intrinsics.checkNotNullExpressionValue((Object)dfIntConstantType, (String)"intValue(...)");
            dfType = (DfType)dfIntConstantType;
        } else if (constantValue instanceof ShortValue) {
            DfIntConstantType dfIntConstantType = DfTypes.intValue((int)((Number)((ShortValue)constant).getValue()).shortValue());
            Intrinsics.checkNotNullExpressionValue((Object)dfIntConstantType, (String)"intValue(...)");
            dfType = (DfType)dfIntConstantType;
        } else if (constantValue instanceof CharValue) {
            DfIntConstantType dfIntConstantType = DfTypes.intValue((int)((Character)((CharValue)constant).getValue()).charValue());
            Intrinsics.checkNotNullExpressionValue((Object)dfIntConstantType, (String)"intValue(...)");
            dfType = (DfType)dfIntConstantType;
        } else if (constantValue instanceof IntValue) {
            DfIntConstantType dfIntConstantType = DfTypes.intValue((int)((Number)((IntValue)constant).getValue()).intValue());
            Intrinsics.checkNotNullExpressionValue((Object)dfIntConstantType, (String)"intValue(...)");
            dfType = (DfType)dfIntConstantType;
        } else if (constantValue instanceof LongValue) {
            DfLongConstantType dfLongConstantType = DfTypes.longValue((long)((Number)((LongValue)constant).getValue()).longValue());
            Intrinsics.checkNotNullExpressionValue((Object)dfLongConstantType, (String)"longValue(...)");
            dfType = (DfType)dfLongConstantType;
        } else if (constantValue instanceof FloatValue) {
            DfFloatConstantType dfFloatConstantType = DfTypes.floatValue((float)((Number)((FloatValue)constant).getValue()).floatValue());
            Intrinsics.checkNotNullExpressionValue((Object)dfFloatConstantType, (String)"floatValue(...)");
            dfType = (DfType)dfFloatConstantType;
        } else if (constantValue instanceof DoubleValue) {
            DfDoubleConstantType dfDoubleConstantType = DfTypes.doubleValue((double)((Number)((DoubleValue)constant).getValue()).doubleValue());
            Intrinsics.checkNotNullExpressionValue((Object)dfDoubleConstantType, (String)"doubleValue(...)");
            dfType = (DfType)dfDoubleConstantType;
        } else {
            DfType dfType2 = DfType.TOP;
            dfType = dfType2;
            Intrinsics.checkNotNullExpressionValue((Object)dfType2, (String)"TOP");
        }
        return dfType;
    }

    @Nullable
    public static final KotlinType getKotlinType(@NotNull KtExpression $this$getKotlinType) {
        ResolvedCall call2;
        Intrinsics.checkNotNullParameter((Object)$this$getKotlinType, (String)"<this>");
        PsiElement parent2 = $this$getKotlinType.getParent();
        if (parent2 instanceof KtDotQualifiedExpression && Intrinsics.areEqual((Object)((KtDotQualifiedExpression)parent2).getSelectorExpression(), (Object)$this$getKotlinType)) {
            parent2 = ((KtDotQualifiedExpression)parent2).getParent();
        }
        while (parent2 instanceof KtParenthesizedExpression) {
            parent2 = ((KtParenthesizedExpression)parent2).getParent();
        }
        if (parent2 instanceof KtBinaryExpressionWithTypeRHS && Intrinsics.areEqual((Object)((KtBinaryExpressionWithTypeRHS)parent2).getOperationReference().getText(), (Object)"as?") && (call2 = ResolutionUtils.resolveToCall$default((KtElement)$this$getKotlinType, null, 1, null)) != null) {
            ClassifierDescriptor typeDescriptor;
            CallableDescriptor callableDescriptor = call2.getResultingDescriptor();
            Intrinsics.checkNotNullExpressionValue((Object)callableDescriptor, (String)"getResultingDescriptor(...)");
            CallableDescriptor descriptor2 = callableDescriptor;
            KotlinType kotlinType = descriptor2.getOriginal().getReturnType();
            ClassifierDescriptor classifierDescriptor = kotlinType != null && (kotlinType = kotlinType.getConstructor()) != null ? kotlinType.getDeclarationDescriptor() : (typeDescriptor = null);
            if (typeDescriptor instanceof TypeParameterDescriptor) {
                List list2 = ((TypeParameterDescriptor)typeDescriptor).getUpperBounds();
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getUpperBounds(...)");
                KotlinType upperBound = (KotlinType)CollectionsKt.singleOrNull((List)list2);
                if (upperBound != null) {
                    return upperBound;
                }
            }
        }
        return ExtendedResolutionApiKt.safeAnalyzeNonSourceRootCode((KtElement)$this$getKotlinType, BodyResolveMode.PARTIAL).getType($this$getKotlinType);
    }

    @Nullable
    public static final KotlinType getArrayElementType(@NotNull KotlinType $this$getArrayElementType) {
        Intrinsics.checkNotNullParameter((Object)$this$getArrayElementType, (String)"<this>");
        if (!KotlinBuiltIns.isArrayOrPrimitiveArray((KotlinType)$this$getArrayElementType)) {
            return null;
        }
        KotlinType kotlinType = TypeUtilsKt.getBuiltIns((KotlinType)$this$getArrayElementType).getArrayElementType($this$getArrayElementType);
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"getArrayElementType(...)");
        KotlinType type2 = kotlinType;
        if (KotlinBuiltIns.isArray((KotlinType)$this$getArrayElementType) && KotlinBuiltIns.isPrimitiveType((KotlinType)type2)) {
            return TypeUtilsKt.makeNullable((KotlinType)type2);
        }
        return type2;
    }

    @NotNull
    public static final PsiPrimitiveType toPsiPrimitiveType(@NotNull KotlinType $this$toPsiPrimitiveType) {
        PsiPrimitiveType psiPrimitiveType;
        FqNameUnsafe fqNameUnsafe;
        Intrinsics.checkNotNullParameter((Object)$this$toPsiPrimitiveType, (String)"<this>");
        ClassifierDescriptor classifierDescriptor = $this$toPsiPrimitiveType.getConstructor().getDeclarationDescriptor();
        Object object = fqNameUnsafe = classifierDescriptor != null ? DescriptorUtilsKt.getFqNameUnsafe((DeclarationDescriptor)((DeclarationDescriptor)classifierDescriptor)) : null;
        if (Intrinsics.areEqual((Object)fqNameUnsafe, (Object)StandardNames.FqNames._int)) {
            PsiPrimitiveType psiPrimitiveType2 = PsiTypes.intType();
            psiPrimitiveType = psiPrimitiveType2;
            Intrinsics.checkNotNullExpressionValue((Object)psiPrimitiveType2, (String)"intType(...)");
        } else if (Intrinsics.areEqual((Object)fqNameUnsafe, (Object)StandardNames.FqNames._long)) {
            PsiPrimitiveType psiPrimitiveType3 = PsiTypes.longType();
            psiPrimitiveType = psiPrimitiveType3;
            Intrinsics.checkNotNullExpressionValue((Object)psiPrimitiveType3, (String)"longType(...)");
        } else if (Intrinsics.areEqual((Object)fqNameUnsafe, (Object)StandardNames.FqNames._short)) {
            PsiPrimitiveType psiPrimitiveType4 = PsiTypes.shortType();
            psiPrimitiveType = psiPrimitiveType4;
            Intrinsics.checkNotNullExpressionValue((Object)psiPrimitiveType4, (String)"shortType(...)");
        } else if (Intrinsics.areEqual((Object)fqNameUnsafe, (Object)StandardNames.FqNames._boolean)) {
            PsiPrimitiveType psiPrimitiveType5 = PsiTypes.booleanType();
            psiPrimitiveType = psiPrimitiveType5;
            Intrinsics.checkNotNullExpressionValue((Object)psiPrimitiveType5, (String)"booleanType(...)");
        } else if (Intrinsics.areEqual((Object)fqNameUnsafe, (Object)StandardNames.FqNames._byte)) {
            PsiPrimitiveType psiPrimitiveType6 = PsiTypes.byteType();
            psiPrimitiveType = psiPrimitiveType6;
            Intrinsics.checkNotNullExpressionValue((Object)psiPrimitiveType6, (String)"byteType(...)");
        } else if (Intrinsics.areEqual((Object)fqNameUnsafe, (Object)StandardNames.FqNames._char)) {
            PsiPrimitiveType psiPrimitiveType7 = PsiTypes.charType();
            psiPrimitiveType = psiPrimitiveType7;
            Intrinsics.checkNotNullExpressionValue((Object)psiPrimitiveType7, (String)"charType(...)");
        } else if (Intrinsics.areEqual((Object)fqNameUnsafe, (Object)StandardNames.FqNames._double)) {
            PsiPrimitiveType psiPrimitiveType8 = PsiTypes.doubleType();
            psiPrimitiveType = psiPrimitiveType8;
            Intrinsics.checkNotNullExpressionValue((Object)psiPrimitiveType8, (String)"doubleType(...)");
        } else if (Intrinsics.areEqual((Object)fqNameUnsafe, (Object)StandardNames.FqNames._float)) {
            PsiPrimitiveType psiPrimitiveType9 = PsiTypes.floatType();
            psiPrimitiveType = psiPrimitiveType9;
            Intrinsics.checkNotNullExpressionValue((Object)psiPrimitiveType9, (String)"floatType(...)");
        } else {
            throw new IllegalArgumentException("Not a primitive analog: " + $this$toPsiPrimitiveType);
        }
        return psiPrimitiveType;
    }

    @Nullable
    public static final RelationType relationFromToken(@NotNull IElementType token) {
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        IElementType iElementType = token;
        return Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.LT) ? RelationType.LT : (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.GT) ? RelationType.GT : (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.LTEQ) ? RelationType.LE : (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.GTEQ) ? RelationType.GE : (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.EQEQ) ? RelationType.EQ : (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.EXCLEQ) ? RelationType.NE : (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.EQEQEQ) ? RelationType.EQ : (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.EXCLEQEQEQ) ? RelationType.NE : null)))))));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public static final LongRangeBinOp mathOpFromToken(@NotNull KtOperationReferenceExpression ref) {
        Intrinsics.checkNotNullParameter((Object)ref, (String)"ref");
        String string = ref.getText();
        if (string == null) return null;
        int n = -1;
        switch (string.hashCode()) {
            case 3555: {
                if (string.equals("or")) {
                    n = 1;
                }
                break;
            }
            case 37: {
                if (string.equals("%")) {
                    n = 2;
                }
                break;
            }
            case 96727: {
                if (string.equals("and")) {
                    n = 3;
                }
                break;
            }
            case 113847: {
                if (string.equals("shl")) {
                    n = 4;
                }
                break;
            }
            case 42: {
                if (string.equals("*")) {
                    n = 5;
                }
                break;
            }
            case 118875: {
                if (string.equals("xor")) {
                    n = 6;
                }
                break;
            }
            case 43: {
                if (string.equals("+")) {
                    n = 7;
                }
                break;
            }
            case 113853: {
                if (string.equals("shr")) {
                    n = 8;
                }
                break;
            }
            case 45: {
                if (string.equals("-")) {
                    n = 9;
                }
                break;
            }
            case 3599400: {
                if (string.equals("ushr")) {
                    n = 10;
                }
                break;
            }
            case 47: {
                if (string.equals("/")) {
                    n = 11;
                }
                break;
            }
        }
        switch (n) {
            case 7: {
                LongRangeBinOp longRangeBinOp = LongRangeBinOp.PLUS;
                return longRangeBinOp;
            }
            case 9: {
                LongRangeBinOp longRangeBinOp = LongRangeBinOp.MINUS;
                return longRangeBinOp;
            }
            case 5: {
                LongRangeBinOp longRangeBinOp = LongRangeBinOp.MUL;
                return longRangeBinOp;
            }
            case 11: {
                LongRangeBinOp longRangeBinOp = LongRangeBinOp.DIV;
                return longRangeBinOp;
            }
            case 2: {
                LongRangeBinOp longRangeBinOp = LongRangeBinOp.MOD;
                return longRangeBinOp;
            }
            case 3: {
                LongRangeBinOp longRangeBinOp = LongRangeBinOp.AND;
                return longRangeBinOp;
            }
            case 1: {
                LongRangeBinOp longRangeBinOp = LongRangeBinOp.OR;
                return longRangeBinOp;
            }
            case 6: {
                LongRangeBinOp longRangeBinOp = LongRangeBinOp.XOR;
                return longRangeBinOp;
            }
            case 4: {
                LongRangeBinOp longRangeBinOp = LongRangeBinOp.SHL;
                return longRangeBinOp;
            }
            case 8: {
                LongRangeBinOp longRangeBinOp = LongRangeBinOp.SHR;
                return longRangeBinOp;
            }
            case 10: {
                LongRangeBinOp longRangeBinOp = LongRangeBinOp.USHR;
                return longRangeBinOp;
            }
            default: {
                return null;
            }
        }
    }

    @Nullable
    public static final LongRangeBinOp mathOpFromAssignmentToken(@NotNull IElementType token) {
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        IElementType iElementType = token;
        return Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.PLUSEQ) ? LongRangeBinOp.PLUS : (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.MINUSEQ) ? LongRangeBinOp.MINUS : (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.MULTEQ) ? LongRangeBinOp.MUL : (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.DIVEQ) ? LongRangeBinOp.DIV : (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.PERCEQ) ? LongRangeBinOp.MOD : null))));
    }

    @Nullable
    public static final LambdaAndParameter getInlineableLambda(@NotNull KtCallExpression expr) {
        FunctionDescriptor descriptor2;
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)expr, (String)"expr");
        List list2 = expr.getLambdaArguments();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getLambdaArguments(...)");
        KtLambdaArgument ktLambdaArgument = (KtLambdaArgument)CollectionsKt.singleOrNull((List)list2);
        if (ktLambdaArgument == null) {
            return null;
        }
        KtLambdaArgument lambdaArgument = ktLambdaArgument;
        KtLambdaExpression ktLambdaExpression = lambdaArgument.getLambdaExpression();
        if (ktLambdaExpression == null) {
            return null;
        }
        KtLambdaExpression lambdaExpression = ktLambdaExpression;
        int index2 = expr.getValueArguments().indexOf(lambdaArgument);
        boolean bl2 = bl = index2 >= 0;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        ResolvedCall resolvedCall = ResolutionUtils.resolveToCall$default((KtElement)expr, null, 1, null);
        if (resolvedCall == null) {
            return null;
        }
        ResolvedCall resolvedCall2 = resolvedCall;
        CallableDescriptor callableDescriptor = resolvedCall2.getResultingDescriptor();
        FunctionDescriptor functionDescriptor = descriptor2 = callableDescriptor instanceof FunctionDescriptor ? (FunctionDescriptor)callableDescriptor : null;
        if (descriptor2 == null || !descriptor2.isInline()) {
            return null;
        }
        ArgumentMapping argumentMapping2 = resolvedCall2.getArgumentMapping((ValueArgument)lambdaArgument);
        ArgumentMatch argumentMatch = argumentMapping2 instanceof ArgumentMatch ? (ArgumentMatch)argumentMapping2 : null;
        if (argumentMatch == null || (argumentMatch = argumentMatch.getValueParameter()) == null) {
            return null;
        }
        ArgumentMatch parameterDescriptor = argumentMatch;
        if (parameterDescriptor.isNoinline()) {
            return null;
        }
        return new LambdaAndParameter(lambdaExpression, (ValueParameterDescriptor)parameterDescriptor);
    }

    @NotNull
    public static final Pair<RelationType, RelationType> getRelationType(@NotNull RangeKtExpressionType $this$getRelationType) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$getRelationType), (String)"<this>");
        return switch (WhenMappings.$EnumSwitchMapping$0[$this$getRelationType.ordinal()]) {
            case 1 -> TuplesKt.to((Object)RelationType.GE, (Object)RelationType.LE);
            case 2, 3 -> TuplesKt.to((Object)RelationType.GE, (Object)RelationType.LT);
            case 4 -> TuplesKt.to((Object)RelationType.LE, (Object)RelationType.GE);
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[RangeKtExpressionType.values().length];
            try {
                nArray[RangeKtExpressionType.RANGE_TO.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RangeKtExpressionType.RANGE_UNTIL.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RangeKtExpressionType.UNTIL.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RangeKtExpressionType.DOWN_TO.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

