/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeInsight.inspections.shared;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.codeInsight.RecursivePropertyAccessUtil;
import org.jetbrains.kotlin.idea.codeinsight.api.applicable.inspections.KotlinApplicableInspectionBase;
import org.jetbrains.kotlin.idea.codeinsight.api.applicable.inspections.KotlinModCommandQuickFix;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtVisitor;
import org.jetbrains.kotlin.psi.VisitorWrappersKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0002\u001c\u001dB\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0015\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\b2\u0006\u0010\t\u001a\u00020\u0003H\u0002J \u0010\n\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u0003H\u0002J.\u0010\r\u001a\u00020\u000e*\u00020\u000f2\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u00032\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0014J \u0010\u0014\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0013H\u0016J\u0010\u0010\u0019\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\u0002H\u0016J\u0016\u0010\u001a\u001a\u0004\u0018\u00010\u0003*\u00020\u001b2\u0006\u0010\f\u001a\u00020\u0002H\u0016\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/idea/codeInsight/inspections/shared/RecursivePropertyAccessorInspection;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/applicable/inspections/KotlinApplicableInspectionBase;", "Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;", "Lorg/jetbrains/kotlin/idea/codeInsight/inspections/shared/RecursivePropertyAccessorInspection$Context;", "<init>", "()V", "getProblemDescription", "", "Lcom/intellij/codeInspection/util/InspectionMessage;", "context", "createQuickFix", "Lorg/jetbrains/kotlin/idea/codeinsight/api/applicable/inspections/KotlinModCommandQuickFix;", "element", "createProblemDescriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "Lcom/intellij/codeInspection/InspectionManager;", "rangeInElement", "Lcom/intellij/openapi/util/TextRange;", "onTheFly", "", "buildVisitor", "Lorg/jetbrains/kotlin/psi/KtVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "isApplicableByPsi", "prepareContext", "Lorg/jetbrains/kotlin/analysis/api/KaSession;", "Context", "AccessType", "kotlin.code-insight.inspections.shared"})
public final class RecursivePropertyAccessorInspection
extends KotlinApplicableInspectionBase<KtSimpleNameExpression, Context> {
    private final String getProblemDescription(Context context) {
        return switch (WhenMappings.$EnumSwitchMapping$0[context.getAccessType().ordinal()]) {
            case 1 -> KotlinBundle.message((String)"recursive.property.accessor", (Object[])new Object[0]);
            case 2 -> KotlinBundle.message((String)"recursive.synthetic.property.accessor", (Object[])new Object[0]);
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private final KotlinModCommandQuickFix<KtSimpleNameExpression> createQuickFix(KtSimpleNameExpression element, Context context) {
        if (!context.getHasBackingField()) {
            return null;
        }
        return new KotlinModCommandQuickFix<KtSimpleNameExpression>(){

            public String getFamilyName() {
                return KotlinBundle.message((String)"replace.with.field.fix.text", (Object[])new Object[0]);
            }

            protected void applyFix(Project project, KtSimpleNameExpression element, ModPsiUpdater updater2) {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                Intrinsics.checkNotNullParameter((Object)updater2, (String)"updater");
                KtPsiFactory factory2 = new KtPsiFactory(project, false, 2, null);
                element.replace((PsiElement)factory2.createExpression("field"));
            }
        };
    }

    @Override
    @NotNull
    protected ProblemDescriptor createProblemDescriptor(@NotNull InspectionManager $this$createProblemDescriptor, @NotNull KtSimpleNameExpression element, @NotNull Context context, @Nullable TextRange rangeInElement, boolean onTheFly) {
        ProblemDescriptor problemDescriptor;
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)$this$createProblemDescriptor, (String)"<this>");
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                problemDescriptor = this.createQuickFix(element, context);
                if (problemDescriptor == null) break block2;
                ProblemDescriptor it = problemDescriptor;
                boolean bl = false;
                LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{it};
                ProblemDescriptor problemDescriptor2 = $this$createProblemDescriptor.createProblemDescriptor((PsiElement)element, rangeInElement, this.getProblemDescription(context), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, onTheFly, localQuickFixArray);
                problemDescriptor = problemDescriptor2;
                if (problemDescriptor2 != null) break block3;
            }
            ProblemDescriptor problemDescriptor3 = $this$createProblemDescriptor.createProblemDescriptor((PsiElement)element, rangeInElement, this.getProblemDescription(context), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, onTheFly, new LocalQuickFix[0]);
            problemDescriptor = problemDescriptor3;
            Intrinsics.checkNotNullExpressionValue((Object)problemDescriptor3, (String)"createProblemDescriptor(...)");
        }
        return problemDescriptor;
    }

    @Override
    @NotNull
    public KtVisitor<?, ?> buildVisitor(@NotNull ProblemsHolder holder2, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder2, (String)"holder");
        return (KtVisitor)VisitorWrappersKt.simpleNameExpressionVisitor(arg_0 -> RecursivePropertyAccessorInspection.buildVisitor$lambda$1(this, holder2, isOnTheFly, arg_0));
    }

    @Override
    public boolean isApplicableByPsi(@NotNull KtSimpleNameExpression element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return RecursivePropertyAccessUtil.INSTANCE.isApplicablePropertyAccessPsi(element) || RecursivePropertyAccessUtil.INSTANCE.isApplicableSyntheticPropertyAccessPsi(element);
    }

    @Override
    @Nullable
    public Context prepareContext(@NotNull KaSession $this$prepareContext, @NotNull KtSimpleNameExpression element) {
        AccessType accessType;
        Intrinsics.checkNotNullParameter((Object)$this$prepareContext, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (RecursivePropertyAccessUtil.INSTANCE.isRecursivePropertyAccess(element, false)) {
            accessType = AccessType.RECURSIVE_PROPERTY_ACCESS;
        } else if (RecursivePropertyAccessUtil.INSTANCE.isRecursiveSyntheticPropertyAccess((KtElement)element)) {
            accessType = AccessType.RECURSIVE_SYNTHETIC_PROPERTY_ACCESS;
        } else {
            return null;
        }
        AccessType accessType2 = accessType;
        return new Context(accessType2, RecursivePropertyAccessUtil.INSTANCE.isInsidePropertyAccessorWithBackingField($this$prepareContext, element));
    }

    private static final Unit buildVisitor$lambda$1(RecursivePropertyAccessorInspection this$0, ProblemsHolder $holder, boolean $isOnTheFly, KtSimpleNameExpression it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.visitTargetElement((KtElement)it, $holder, $isOnTheFly);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/idea/codeInsight/inspections/shared/RecursivePropertyAccessorInspection$AccessType;", "", "<init>", "(Ljava/lang/String;I)V", "RECURSIVE_PROPERTY_ACCESS", "RECURSIVE_SYNTHETIC_PROPERTY_ACCESS", "kotlin.code-insight.inspections.shared"})
    public static final class AccessType
    extends Enum<AccessType> {
        public static final /* enum */ AccessType RECURSIVE_PROPERTY_ACCESS = new AccessType();
        public static final /* enum */ AccessType RECURSIVE_SYNTHETIC_PROPERTY_ACCESS = new AccessType();
        private static final /* synthetic */ AccessType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static AccessType[] values() {
            return (AccessType[])$VALUES.clone();
        }

        public static AccessType valueOf(String value) {
            return Enum.valueOf(AccessType.class, value);
        }

        @NotNull
        public static EnumEntries<AccessType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = accessTypeArray = new AccessType[]{AccessType.RECURSIVE_PROPERTY_ACCESS, AccessType.RECURSIVE_SYNTHETIC_PROPERTY_ACCESS};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/codeInsight/inspections/shared/RecursivePropertyAccessorInspection$Context;", "", "accessType", "Lorg/jetbrains/kotlin/idea/codeInsight/inspections/shared/RecursivePropertyAccessorInspection$AccessType;", "hasBackingField", "", "<init>", "(Lorg/jetbrains/kotlin/idea/codeInsight/inspections/shared/RecursivePropertyAccessorInspection$AccessType;Z)V", "getAccessType", "()Lorg/jetbrains/kotlin/idea/codeInsight/inspections/shared/RecursivePropertyAccessorInspection$AccessType;", "getHasBackingField", "()Z", "kotlin.code-insight.inspections.shared"})
    public static final class Context {
        @NotNull
        private final AccessType accessType;
        private final boolean hasBackingField;

        public Context(@NotNull AccessType accessType, boolean hasBackingField) {
            Intrinsics.checkNotNullParameter((Object)((Object)accessType), (String)"accessType");
            this.accessType = accessType;
            this.hasBackingField = hasBackingField;
        }

        @NotNull
        public final AccessType getAccessType() {
            return this.accessType;
        }

        public final boolean getHasBackingField() {
            return this.hasBackingField;
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[AccessType.values().length];
            try {
                nArray[AccessType.RECURSIVE_PROPERTY_ACCESS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AccessType.RECURSIVE_SYNTHETIC_PROPERTY_ACCESS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

