/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.cli;

import org.gradle.api.internal.StartParameterInternal;
import org.gradle.configuration.GradleLauncherMetaData;
import org.gradle.initialization.BuildCancellationToken;
import org.gradle.initialization.BuildEventConsumer;
import org.gradle.initialization.DefaultBuildCancellationToken;
import org.gradle.initialization.NoOpBuildEventConsumer;
import org.gradle.initialization.ReportedException;
import org.gradle.internal.concurrent.Stoppable;
import org.gradle.internal.daemon.client.execution.ClientBuildRequestContext;
import org.gradle.internal.invocation.BuildAction;
import org.gradle.internal.nativeintegration.console.ConsoleDetector;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.launcher.exec.BuildActionExecutor;
import org.gradle.launcher.exec.BuildActionParameters;
import org.gradle.launcher.exec.BuildActionResult;
import org.gradle.tooling.internal.provider.action.ExecuteBuildAction;

public class RunBuildAction
implements Runnable {
    private final BuildActionExecutor<BuildActionParameters, ClientBuildRequestContext> executor;
    private final StartParameterInternal startParameter;
    private final GradleLauncherMetaData clientMetaData;
    private final long startTime;
    private final BuildActionParameters buildActionParameters;
    private final ServiceRegistry sharedServices;
    private final Stoppable stoppable;

    public RunBuildAction(BuildActionExecutor<BuildActionParameters, ClientBuildRequestContext> executor, StartParameterInternal startParameter, GradleLauncherMetaData clientMetaData, long startTime, BuildActionParameters buildActionParameters, ServiceRegistry sharedServices, Stoppable stoppable) {
        this.executor = executor;
        this.startParameter = startParameter;
        this.clientMetaData = clientMetaData;
        this.startTime = startTime;
        this.buildActionParameters = buildActionParameters;
        this.sharedServices = sharedServices;
        this.stoppable = stoppable;
    }

    @Override
    public void run() {
        try {
            BuildActionResult result = this.executor.execute((BuildAction)new ExecuteBuildAction(this.startParameter), (Object)this.buildActionParameters, (Object)new ClientBuildRequestContext(this.clientMetaData, this.startTime, ((ConsoleDetector)this.sharedServices.get(ConsoleDetector.class)).isConsoleInput(), (BuildCancellationToken)new DefaultBuildCancellationToken(), (BuildEventConsumer)new NoOpBuildEventConsumer()));
            if (result.hasFailure()) {
                throw new ReportedException();
            }
        }
        finally {
            this.stoppable.stop();
        }
    }
}

