/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file.collections;

import java.io.File;
import java.util.Set;
import java.util.function.Consumer;
import org.gradle.api.Buildable;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.FileVisitor;
import org.gradle.api.internal.file.AbstractFileTree;
import org.gradle.api.internal.file.FileCollectionStructureVisitor;
import org.gradle.api.internal.file.FileTreeInternal;
import org.gradle.api.internal.file.collections.FileCollectionObservationListener;
import org.gradle.api.internal.file.collections.FileSystemMirroringFileTree;
import org.gradle.api.internal.file.collections.FilteredMinimalFileTree;
import org.gradle.api.internal.file.collections.GeneratedSingletonFileTree;
import org.gradle.api.internal.file.collections.MinimalFileTree;
import org.gradle.api.internal.file.collections.PatternFilterableFileTree;
import org.gradle.api.internal.file.collections.RandomAccessFileCollection;
import org.gradle.api.internal.tasks.TaskDependencyContainer;
import org.gradle.api.internal.tasks.TaskDependencyFactory;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;
import org.gradle.api.tasks.util.PatternFilterable;
import org.gradle.api.tasks.util.PatternSet;
import org.gradle.api.tasks.util.internal.PatternSetFactory;
import org.gradle.internal.logging.text.TreeFormatter;

public final class FileTreeAdapter
extends AbstractFileTree {
    private final MinimalFileTree tree;
    private final FileCollectionObservationListener listener;

    public FileTreeAdapter(MinimalFileTree tree, FileCollectionObservationListener listener, TaskDependencyFactory taskDependencyFactory, PatternSetFactory patternSetFactory) {
        super(taskDependencyFactory, patternSetFactory);
        this.tree = tree;
        this.listener = listener;
    }

    public FileTreeAdapter(MinimalFileTree tree, TaskDependencyFactory taskDependencyFactory, PatternSetFactory patternSetFactory) {
        this(tree, fileCollection -> {}, taskDependencyFactory, patternSetFactory);
    }

    @Override
    public Set<File> getFiles() {
        this.listener.fileCollectionObserved(this);
        return super.getFiles();
    }

    public MinimalFileTree getTree() {
        return this.tree;
    }

    @Override
    public String getDisplayName() {
        return this.tree.getDisplayName();
    }

    @Override
    protected void appendContents(TreeFormatter formatter) {
        formatter.node("tree: " + this.tree);
    }

    @Override
    public void visitDependencies(TaskDependencyResolveContext context) {
        if (this.tree instanceof Buildable) {
            context.add((Object)this.tree);
        } else if (this.tree instanceof TaskDependencyContainer) {
            ((TaskDependencyContainer)this.tree).visitDependencies(context);
        }
    }

    @Override
    public boolean contains(File file) {
        if (this.tree instanceof RandomAccessFileCollection) {
            RandomAccessFileCollection randomAccess = (RandomAccessFileCollection)((Object)this.tree);
            return randomAccess.contains(file);
        }
        if (this.tree instanceof GeneratedSingletonFileTree) {
            return ((GeneratedSingletonFileTree)this.tree).getFileWithoutCreating().equals(file);
        }
        if (this.tree instanceof FileSystemMirroringFileTree) {
            return ((FileSystemMirroringFileTree)this.tree).getMirror().contains(file);
        }
        return super.contains(file);
    }

    @Override
    public FileTreeInternal matching(PatternFilterable patterns) {
        if (this.tree instanceof PatternFilterableFileTree) {
            PatternFilterableFileTree filterableTree = (PatternFilterableFileTree)this.tree;
            return new FileTreeAdapter(filterableTree.filter(patterns), this.listener, this.taskDependencyFactory, this.patternSetFactory);
        }
        if (this.tree instanceof FileSystemMirroringFileTree) {
            return new FileTreeAdapter(new FilteredMinimalFileTree((PatternSet)patterns, (FileSystemMirroringFileTree)this.tree), this.listener, this.taskDependencyFactory, this.patternSetFactory);
        }
        throw new UnsupportedOperationException(String.format("Do not know how to filter %s.", this.tree));
    }

    public FileTree visit(FileVisitor visitor) {
        this.tree.visit(visitor);
        return this;
    }

    @Override
    public void visitContentsAsFileTrees(Consumer<FileTreeInternal> visitor) {
        visitor.accept(this);
    }

    @Override
    protected void visitContents(final FileCollectionStructureVisitor visitor) {
        this.tree.visitStructure(new MinimalFileTree.MinimalFileTreeStructureVisitor(){

            @Override
            public void visitFileTree(File root, PatternSet patterns, FileTreeInternal fileTree) {
                visitor.visitFileTree(root, patterns, fileTree);
            }

            @Override
            public void visitFileTreeBackedByFile(File file, FileTreeInternal fileTree, FileSystemMirroringFileTree sourceTree) {
                visitor.visitFileTreeBackedByFile(file, fileTree, sourceTree);
            }
        }, this);
    }
}

