/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.bcpg;

import java.io.IOException;
import java.io.InputStream;
import java.security.SecureRandom;
import org.bouncycastle.bcpg.BCPGInputStream;
import org.bouncycastle.bcpg.BCPGOutputStream;
import org.bouncycastle.bcpg.ContainedPacket;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.io.Streams;

public class PaddingPacket
extends ContainedPacket {
    private final byte[] padding;

    public PaddingPacket(BCPGInputStream bCPGInputStream) throws IOException {
        this(bCPGInputStream, true);
    }

    public PaddingPacket(BCPGInputStream bCPGInputStream, boolean bl) throws IOException {
        super(21, bl);
        this.padding = Streams.readAll((InputStream)bCPGInputStream);
    }

    public PaddingPacket(byte[] byArray) {
        super(21, true);
        this.padding = byArray;
    }

    public PaddingPacket(int n, SecureRandom secureRandom) {
        this(PaddingPacket.randomBytes(n, secureRandom));
    }

    private static byte[] randomBytes(int n, SecureRandom secureRandom) {
        if (n <= 0) {
            throw new IllegalArgumentException("Octet count MUST NOT be 0 nor negative.");
        }
        byte[] byArray = new byte[n];
        secureRandom.nextBytes(byArray);
        return byArray;
    }

    public byte[] getPadding() {
        return Arrays.clone((byte[])this.padding);
    }

    @Override
    public void encode(BCPGOutputStream bCPGOutputStream) throws IOException {
        bCPGOutputStream.writePacket(this.hasNewPacketFormat(), 21, this.padding);
    }
}

