/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.detection;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.gradle.api.GradleException;
import org.gradle.api.internal.tasks.testing.detection.JarFilePackageListener;
import org.gradle.internal.FileUtils;

public class JarFilePackageLister {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void listJarPackages(File jarFile, JarFilePackageListener listener) {
        if (jarFile == null) {
            throw new IllegalArgumentException("jarFile is null!");
        }
        String jarFileAbsolutePath = jarFile.getAbsolutePath();
        if (!jarFile.exists()) {
            throw new IllegalArgumentException("jarFile doesn't exists! (" + jarFileAbsolutePath + ")");
        }
        if (!jarFile.isFile()) {
            throw new IllegalArgumentException("jarFile is not a file! (" + jarFileAbsolutePath + ")");
        }
        if (!FileUtils.hasExtension((File)jarFile, (String)".jar")) {
            throw new IllegalArgumentException("jarFile is not a jarFile! (" + jarFileAbsolutePath + ")");
        }
        try (ZipFile zipFile = new ZipFile(jarFile);){
            Enumeration<? extends ZipEntry> zipFileEntries = zipFile.entries();
            while (zipFileEntries.hasMoreElements()) {
                ZipEntry zipEntry = zipFileEntries.nextElement();
                String entryName = zipEntry.getName();
                String packageName = zipEntry.isDirectory() ? entryName : entryName.substring(0, entryName.lastIndexOf("/") + 1);
                if (packageName.startsWith("META-INF")) continue;
                listener.receivePackage(packageName);
            }
        }
        catch (IOException e) {
            throw new GradleException("failed to scan jar file for packages (" + jarFileAbsolutePath + ")", (Throwable)e);
        }
    }
}

