/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.result;

import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.Set;
import javax.annotation.concurrent.NotThreadSafe;
import org.gradle.api.artifacts.capability.CapabilitySelector;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.artifacts.component.LibraryComponentSelector;
import org.gradle.api.artifacts.component.ModuleComponentSelector;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.internal.artifacts.ModuleComponentSelectorSerializer;
import org.gradle.api.internal.artifacts.capability.CapabilitySelectorSerializer;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.AttributeContainerSerializer;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.PathSerializer;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ProjectIdentitySerializer;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.project.ProjectIdentity;
import org.gradle.internal.component.external.model.DefaultModuleComponentSelector;
import org.gradle.internal.component.local.model.DefaultLibraryComponentSelector;
import org.gradle.internal.component.local.model.DefaultProjectComponentSelector;
import org.gradle.internal.serialize.AbstractSerializer;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;

@NotThreadSafe
public class ComponentSelectorSerializer
extends AbstractSerializer<ComponentSelector> {
    private final AttributeContainerSerializer attributeContainerSerializer;
    private final CapabilitySelectorSerializer capabilitySelectorSerializer;
    private final ProjectIdentitySerializer projectIdentitySerializer;
    private final ModuleComponentSelectorSerializer moduleComponentSelectorSerializer;

    public ComponentSelectorSerializer(AttributeContainerSerializer attributeContainerSerializer, CapabilitySelectorSerializer capabilitySelectorSerializer) {
        this.attributeContainerSerializer = attributeContainerSerializer;
        this.capabilitySelectorSerializer = capabilitySelectorSerializer;
        this.projectIdentitySerializer = new ProjectIdentitySerializer(new PathSerializer());
        this.moduleComponentSelectorSerializer = new ModuleComponentSelectorSerializer(attributeContainerSerializer, capabilitySelectorSerializer);
    }

    public ComponentSelector read(Decoder decoder) throws IOException {
        byte id = decoder.readByte();
        if (Implementation.PROJECT.getId() == id) {
            ProjectIdentity projectId = this.projectIdentitySerializer.read(decoder);
            ImmutableAttributes attributes = this.readAttributes(decoder);
            ImmutableSet<CapabilitySelector> capabilitySelectors = this.readCapabilitySelectors(decoder);
            return new DefaultProjectComponentSelector(projectId, attributes, capabilitySelectors);
        }
        if (Implementation.MODULE.getId() == id) {
            return this.moduleComponentSelectorSerializer.read(decoder);
        }
        if (Implementation.LIBRARY.getId() == id) {
            return new DefaultLibraryComponentSelector(decoder.readString(), decoder.readNullableString(), decoder.readNullableString());
        }
        throw new IllegalArgumentException("Unable to find component selector with id: " + id);
    }

    private ImmutableAttributes readAttributes(Decoder decoder) throws IOException {
        return this.attributeContainerSerializer.read(decoder);
    }

    private ImmutableSet<CapabilitySelector> readCapabilitySelectors(Decoder decoder) throws IOException {
        int size = decoder.readSmallInt();
        if (size == 0) {
            return ImmutableSet.of();
        }
        ImmutableSet.Builder builder = ImmutableSet.builderWithExpectedSize((int)size);
        for (int i = 0; i < size; ++i) {
            builder.add((Object)this.capabilitySelectorSerializer.read(decoder));
        }
        return builder.build();
    }

    private void writeCapabilitySelectors(Encoder encoder, Set<CapabilitySelector> capabilitySelectors) throws IOException {
        encoder.writeSmallInt(capabilitySelectors.size());
        for (CapabilitySelector capabilitySelector : capabilitySelectors) {
            this.capabilitySelectorSerializer.write(encoder, capabilitySelector);
        }
    }

    public void write(Encoder encoder, ComponentSelector value) throws IOException {
        if (value == null) {
            throw new IllegalArgumentException("Provided component selector may not be null");
        }
        Implementation implementation = ComponentSelectorSerializer.resolveImplementation(value);
        encoder.writeByte(implementation.getId());
        if (implementation == Implementation.MODULE) {
            this.moduleComponentSelectorSerializer.write(encoder, (ModuleComponentSelector)value);
        } else if (implementation == Implementation.PROJECT) {
            DefaultProjectComponentSelector projectComponentSelector = (DefaultProjectComponentSelector)value;
            this.projectIdentitySerializer.write(encoder, projectComponentSelector.getProjectIdentity());
            this.writeAttributes(encoder, projectComponentSelector.getAttributes());
            this.writeCapabilitySelectors(encoder, (Set<CapabilitySelector>)projectComponentSelector.getCapabilitySelectors());
        } else if (implementation == Implementation.LIBRARY) {
            LibraryComponentSelector libraryComponentSelector = (LibraryComponentSelector)value;
            encoder.writeString((CharSequence)libraryComponentSelector.getProjectPath());
            encoder.writeNullableString((CharSequence)libraryComponentSelector.getLibraryName());
            encoder.writeNullableString((CharSequence)libraryComponentSelector.getVariant());
        } else {
            throw new IllegalStateException("Unsupported implementation type: " + (Object)((Object)implementation));
        }
    }

    private void writeAttributes(Encoder encoder, ImmutableAttributes attributes) throws IOException {
        this.attributeContainerSerializer.write(encoder, (AttributeContainer)attributes);
    }

    private static Implementation resolveImplementation(ComponentSelector value) {
        if (value instanceof DefaultModuleComponentSelector) {
            return Implementation.MODULE;
        }
        if (value instanceof DefaultProjectComponentSelector) {
            return Implementation.PROJECT;
        }
        if (value instanceof DefaultLibraryComponentSelector) {
            return Implementation.LIBRARY;
        }
        throw new IllegalArgumentException("Unsupported component selector class: " + value.getClass());
    }

    private static enum Implementation {
        MODULE(1),
        PROJECT(2),
        LIBRARY(6);

        private final byte id;

        private Implementation(int id) {
            this.id = (byte)id;
        }

        byte getId() {
            return this.id;
        }
    }
}

