/*
 * Decompiled with CFR 0.152.
 */
package org.python.google.common.cache;

import java.util.concurrent.Executor;
import org.python.google.common.annotations.GwtIncompatible;
import org.python.google.common.base.Preconditions;
import org.python.google.common.cache.ElementTypesAreNonnullByDefault;
import org.python.google.common.cache.RemovalListener;

@ElementTypesAreNonnullByDefault
@GwtIncompatible
public final class RemovalListeners {
    private RemovalListeners() {
    }

    public static <K, V> RemovalListener<K, V> asynchronous(RemovalListener<K, V> listener, Executor executor) {
        Preconditions.checkNotNull(listener);
        Preconditions.checkNotNull(executor);
        return notification -> executor.execute(() -> listener.onRemoval(notification));
    }
}

